#!/usr/local/bin/perl -w

# Translate Yivo input into html form
# was y2h.sed, but in Perl we have finer control.
# Raphael Finkel 11/1999

print "<html><head><title>\n" ,
	"</title></head><body>\n";

$exact = 0; # unless turned on later
while (defined ($line = <>)) { # one line of input
	if ($line =~ /^\s*$/ and $exact == 0) { # empty
		print "<p>\n";
		next;
	}
	$line =~ s/^\s*\\english{(.*)}.*$/<em>$1<\/em>\n/; # English request
	$line =~ s/\\\\/<br>/g; # new line request
	if ($line =~ /(deadsea|jerusalem|telaviv|jaffa|classic|calig){(\d+)}/) {
		$size = $2;
		if ($size == 2000) {
			print "<font size=5>\n";
		} elsif ($size == 1500) {
			print "<font size=4>\n";
		} elsif ($size == 1000) {
			print "<font size=3>\n";
		}
	}
	if ($line =~ /^\s*\\exact\s*$/) {
		$exact = 1;
	}
	if ($line =~ /\\hrule/) {
		print "<br clear=all><p>" .
			"<IMG SRC=../../rnb-line.gif WIDTH=60% HEIGHT=4 alt=\"\">" .
			"<p><br clear=all>\n";
		next;
	}
	if ($line =~ /\\/) {next;} # TeX command; ignore
	if ($exact == 1) {
		$line =~ s/^( +)/"&nbsp;" x (length $1)/e;
		$line =~ s/^(\t+)/"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" x (length $1)/e;
		print "<br>";
	}
	print $line;
}

print "</body></html>\n";
