#!/usr/local/bin/perl

# convert Unicode U16 to UTF-8 form.
# Raphael Finkel <raphael@cs.uky.edu> 12/1999

# if you get gibberish out, try reversing the two parameters below

while (read(STDIN,$first,1) > 0) {
	read(STDIN,$second,1);
	print ToUTF($first,$second); # try reversing these two parameters
}

sub ToUTF {
	local($left, $right) = @_;
	$mychar = ord($left) * 256 + ord($right);
	if ($mychar <= 0x7F) { # 7 sig bits; plain 7-bit ascii
		return chr $mychar;
	} elsif ($mychar <= 0x7FF) { # 11 sig bits; Hebrew is in this range */
		$first = chr(0300 | ($mychar >> 6)&037);
		$second = chr(0200 | $mychar & 077);
		return "$first$second";
	} elsif ($mychar <= 0xFFFF) { # 16 sig bits */
		$first = chr(0340 | (($mychar >> 12)&017));
		$second = chr(0200 | (($mychar >> 6)&077));
		$third = chr(0200 | ($mychar & 077));
		return "$first$second$third";
	}
} # ToUTF
