/* this program respells input by substituting words in a correction list */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAXWORD 30
#define NUMWORDS 6000
#define WORDSPACE (NUMWORDS * 20)
/* go through a file looking for keywords from a list (see below)
and respell them. */

char *badwords[NUMWORDS], *goodwords[NUMWORDS];
char wordspace[WORDSPACE];
int numwords; /* how much of badwords, goodwords is occupied. */
int next;
FILE *in, *out, *data;

int getword(char *s);

char *
FindAndReplace(s)
char *s;
{
	char **low, **high, **probe; /* indices into badwords */
	low = badwords;
	high = badwords+numwords-1;
	while (low < high){
		probe = low + (high-low)/2;
		if (strcmp(*probe, s) < 0) low = probe+1;
		else high = probe;
	}
	if (strcmp(*low, s)==0){ /* success */
		return(*(low+(goodwords-badwords))); /* replacement text */
	} else { /* failure */
		return(s);
	}
} /* FindAndReplace */

int main(int argc, char *argv[]) {
	char word[MAXWORD];
	int count;
	char *wordptr;
	char *wordspaceptr;
	
	if (argc!=4) {
		fprintf(stderr,"usage: %s datafile infile outfile\n",argv[0]);
		fprintf(stderr,"\tUse - for stdin and/or stdout\n");
		exit(1);
	}
	/* read in data file */
	data=fopen(argv[1],"r");
	if (data==NULL){
		fprintf(stderr,"Can't open %s\n",argv[1]);
		exit(1);
	}
	wordspaceptr = wordspace;
	count = 0;
	while (1) { /* exit from middle */
		next=getc(data);
		if (next==EOF) break;
		badwords[count] = wordspaceptr;
		while (next != ' '){
			*wordspaceptr++ = next;
			next=getc(data);
		}
		*wordspaceptr++ = '\0';
		next=getc(data);
		goodwords[count] = wordspaceptr;
		while (next != '\n'){
			*wordspaceptr++ = next;
			next=getc(data);
		}
		*wordspaceptr++ = '\0';
		// printf("%s: %s\n", badwords[count], goodwords[count]);
		count++;
		if (count >= NUMWORDS) {
			fprintf(stderr, "Too many words in %s; increase NUMWORDS in %s\n",
				argv[1], argv[0]);
			exit(1);
		}
	}
	badwords[count] = "zzzzz";
	badwords[count+1] = 0;
	goodwords[count] = 0;
	numwords = count;

	if (strcmp("-",argv[2])) {
		in = fopen(argv[2],"r");
		if (in==NULL){
			fprintf(stderr,"Can't open %s\n",argv[2]);
			exit(1);
		}
	} else {
		in = stdin;
		argv[2] = "stdin";
	}
	if (strcmp("-",argv[3])) {
		data = fopen(argv[3],"r");
		out=fopen(argv[3],"r");
		if (out != NULL){
			fprintf(stderr,"%s already exists.\n",argv[3]);
			exit(1);
		}
		out=fopen(argv[3],"w");
		if (out==NULL){
			fprintf(stderr,"Can't open %s\n",argv[3]);
			exit(1);
		}
	} else {
		out = stdout;
		argv[3] = "stdout";
	}
	next=getc(in);
	while(getword(word)) {
		wordptr = FindAndReplace(word);
		count=strlen(wordptr);
		fprintf(out,"%s",wordptr);
	}
	return(0);
} /* main */

int getword(s) char *s; {
	while (! ( (next>='a' && next<='z') || next == '#' || (next>='A' && next<='Z') ||
		(next >='0' && next <= '9') )) {
		if (next == '\\') { /* flush to end of line */
			while (next != '\n') {
				putc(next,out);
				next=getc(in);
			}
		}
		putc(next,out);
		next=getc(in);
		if (next==EOF) return(0);
	}
	do {
		*s++ = next;
		next=getc(in);
	} while (
		(next>='a'&&next<='z') ||
		(next>='A'&&next<='Z') ||
		(next == '_') ||
		(next == '#') ||
			 /* used to allow | also, but we want that as a separator now */
		(next>='0'&&next<='9') );
	*s=0;
	return(1);
}
