
#include"xmx.h"
#include<X11/Xlib.h>
#define NEED_EVENTS
#define NEED_REPLIES

#define background_pixmap	0
#define border_pixmap		2
#define event_mask		11
#define colormap		13
#define Cursor			14

#define tile			10
#define stipple			11
#define Font			14
#define	clip_mask		19


extern char *packet;
extern unsigned long data_left, data;
extern int max_len;
/*
 ***************************************************************************
 * structure to traverse through the value list
 ***************************************************************************
 */

typedef struct _value_t{
     CARD32 value;
}value_t;

void init_buff(char *);
/*
 *=========================================================================
 * Receive the message from the socket and copy it in the buffer
 *=========================================================================
 */

int
recv_request(sockfd, buffer, len)
int sockfd;
char *buffer;
int len;
{
    unsigned int nread, nleft, r;
    fd_set rdfds;
    struct timeval timeout;
    char *data;

    timeout.tv_sec = 0;
    timeout.tv_usec = 0;
    nleft = max_len;
    data = buffer + data_left;

    /****
    for(nleft = 0; nleft < max_len; nleft += nread, buffer += nread) {
    ****/
    while( nleft > 0) {
	nread = read(sockfd, (char *)data, nleft);
	if(nread < 0)
	    return nread;
        else if( nread == 0 )
	    break;
	FD_ZERO(&rdfds);
	FD_SET(sockfd, &rdfds);
	r = select(sockfd+1, &rdfds, (fd_set *)0, (fd_set *)0, &timeout);
	if( r == 0) {
	    nleft -= nread;
	    break;
	}
	nleft -= nread;
	data += nread;

    }
    return (max_len - nleft);
}

/****
int
recv_reply(sockfd, buffer, len, server_is)
int sockfd;
char *buffer;
int len, server_is;
{
    unsigned int nread, nleft, r;
    fd_set rdfds;
    struct timeval timeout;
    int temp_data;

    if( server_is == MASTER )
      temp_data = reply_data_left;
    else
      temp_data = slave_data_left;

    timeout.tv_sec = 0;
    timeout.tv_usec = 0;

    for(nleft = 0; nleft < 1000; nleft += nread, buffer += nread) {
	nread = read(sockfd, (buffer + temp_data), 1000);
	if(nread <= 0) {
	    if( nread == 0 )
		return 0;
	    else
		return -1;
	}
	FD_ZERO(&rdfds);
	FD_SET(sockfd, &rdfds);
	r = select(sockfd+1, &rdfds, (fd_set *)0, (fd_set *)0, &timeout);
	if( r == 0) {
	    nleft = nleft + nread;
	    break;
	}
	continue;
    }
    return nleft;
}
***/

/*
 *************************************************************************
 * This function returns the pointer to the next request. Rest of the
 * buffer contains at least as much active data as the next available
 * request's size. If request is larger than the remaining data, then
 * it returns zero.
 *************************************************************************
 */

 get_request(buff, cp)
 char *buff;
 char **cp;
 {
     int nleft, len;

    if(*cp) {
	*cp += ((*((xReq **)cp))->length << 2);
	nleft = data - (*cp - buff);
    }

    else {
	*cp = buff;
	nleft = data;
    }

    len = (*((xReq **)cp))->length << 2;
    if(len > nleft)
	len = 0;

    return len;
}

/*
 **************************************************************************
 *
 * Filter the requests before sending it to the slave.
 *
 **************************************************************************
 */

int filter_request(data)
char *data;
{
    xReq *request;

    request = (xReq *)data;
    switch(request->reqType) {
	case X_CreateWindow:		return 1;
	case X_ChangeWindowAttributes:	return 1;
	case X_GetWindowAttributes:	return 0;
	case X_DestroyWindow:		return 1;
	case X_DestroySubwindows:	return 1;
	case X_ChangeSaveSet:		return 1;
	case X_ReparentWindow:		return 1;
	case X_MapWindow:		return 1;
	case X_MapSubwindows:		return 1;
	case X_UnmapWindow:		return 1;
	case X_UnmapSubwindows:		return 1;
	case X_ConfigureWindow:		return 1;
	case X_CirculateWindow:		return 1;
	case X_GetGeometry:		return 0;
	case X_QueryTree:		return 0;
	case X_InternAtom:		return 1;
	case X_GetAtomName:		return 0;
	case X_ChangeProperty:		return 1;
	case X_DeleteProperty:		return 0;
	case X_GetProperty:		return 0; 
	case X_ListProperties:		return 0;
	case X_SetSelectionOwner:	return 0;
	case X_GetSelectionOwner:	return 0;
	case X_ConvertSelection:	return 0;
	case X_SendEvent:		return 0;
	case X_GrabPointer:		return 0;
	case X_UngrabPointer:		return 0;
	case X_GrabButton:		return 0;
	case X_UngrabButton:		return 0;
	case X_ChangeActivePointerGrab:	return 0;
	case X_GrabKeyboard:		return 0;
	case X_UngrabKeyboard:		return 0;
	case X_GrabKey:			return 0;
	case X_UngrabKey:		return 0;
	case X_AllowEvents:		return 0;
	case X_GrabServer:		return 0;
	case X_UngrabServer:		return 0;
	case X_QueryPointer:		return 0;
	case X_GetMotionEvents:		return 0;
	case X_TranslateCoords:		return 0;
	case X_WarpPointer:		return 1;
	case X_SetInputFocus:		return 0;
	case X_GetInputFocus:		return 0;
	case X_QueryKeymap:		return 0;
	case X_OpenFont:		return 1;
	case X_CloseFont:		return 1;
	case X_QueryFont:		return 0;
	case X_QueryTextExtents:	return 0;
	case X_ListFonts:		return 0;
	case X_ListFontsWithInfo:	return 0;
	case X_SetFontPath:		return 1;
	case X_GetFontPath:		return 0;
	case X_CreatePixmap:		return 1;
	case X_FreePixmap:		return 1;
	case X_CreateGC:		return 1;
	case X_ChangeGC:		return 1;
	case X_CopyGC:			return 1;
	case X_SetDashes:		return 1;
	case X_SetClipRectangles:	return 1;
	case X_FreeGC:			return 1;
	case X_ClearArea:		return 1;
	case X_CopyArea:		return 1;
	case X_CopyPlane:		return 1;
	case X_PolyPoint:		return 1;
	case X_PolyLine:		return 1;
	case X_PolySegment:		return 1;
	case X_PolyRectangle:		return 1;
	case X_PolyArc:			return 1;
	case X_FillPoly:		return 1;
	case X_PolyFillRectangle:	return 1;
	case X_PolyFillArc:		return 1;
	case X_PutImage:		return 1;
	case X_GetImage:		return 0;
	case X_PolyText8:		return 1;
	case X_PolyText16:		return 1;
	case X_ImageText8:		return 1;
	case X_ImageText16:		return 1;
	case X_CreateColormap:		return 1;
	case X_FreeColormap:		return 1;
	case X_CopyColormapAndFree:	return 1;
	case X_InstallColormap:		return 1;
	case X_UninstallColormap:	return 1;
	case X_ListInstalledColormaps:	return 0;
	case X_AllocColor:		return 1;
	case X_AllocNamedColor:		return 1;
	case X_AllocColorCells:		return 1;
	case X_AllocColorPlanes:	return 1;
	case X_FreeColors:		return 1;
	case X_StoreColors:		return 1;
	case X_StoreNamedColor:		return 1;
	case X_QueryColors:		return 0;
	case X_LookupColor:		return 0;
	case X_CreateCursor:		return 1;
	case X_CreateGlyphCursor:	return 1;
	case X_FreeCursor:		return 1;
	case X_RecolorCursor:		return 1;
	case X_QueryBestSize:		return 0;
	case X_QueryExtension:		return 0;
	case X_ListExtensions:		return 0;
	case X_ChangeKeyboardMapping:	return 0;
	case X_GetKeyboardMapping:	return 0;
	case X_ChangeKeyboardControl:	return 0;
	case X_GetKeyboardControl:	return 0;
	case X_Bell:			return 1;
	case X_ChangePointerControl:	return 0;
	case X_GetPointerControl:	return 0;
	case X_SetScreenSaver:		return 1;
	case X_GetScreenSaver:		return 0;
	case X_ChangeHosts:		return 1;
	case X_ListHosts:		return 0;
	case X_SetAccessControl:	return 1;
	case X_SetCloseDownMode:	return 0;
	case X_KillClient:		return 0;
	case X_RotateProperties:	return 1;
	case X_ForceScreenSaver:	return 1;
	case X_SetPointerMapping:	return 0;
	case X_GetPointerMapping:	return 0;
	case X_SetModifierMapping:	return 0;
	case X_GetModifierMapping:	return 0;
	case X_NoOperation:		return 1;
    }
    return 0;
}

/*
 ****************************************************************************
 * map request:
 * map the ids from master id's to slave's id's, because client is
 * talking only with the master 
 *
 ****************************************************************************
 */

int
map_request(s, data, buff, atoms, slv_fd)
int s;
char *data;
char *buff;
ATOM *atoms;
int slv_fd;
{
    xReq *request;
    char *temp, *foo;
    int i;
    CARD32 m;

    request = (xReq *)data;
    temp = buff;
    foo = data;
    switch(request->reqType) {
	/* opcode 1 */
	case X_CreateWindow:
	{
	    ((xCreateWindowReq *)foo)->parent = 
	      map_ids(s, ((xCreateWindowReq *)temp)->parent);
	    ((xCreateWindowReq *)foo)->wid = 
	      map_ids(s, ((xCreateWindowReq *)temp)->wid);
	    if(((xCreateWindowReq *)temp)->visual == 0);
	    else 
		((xCreateWindowReq *)foo)->visual = 
		  map_ids(s, ((xCreateWindowReq *)temp)->visual);
	    /* check for the values in the mask */
	    foo = foo + sz_xCreateWindowReq;
            temp = temp + sz_xCreateWindowReq;

	    for(i = 0, m = ((xCreateWindowReq *)data)->mask; m; m = m >> 1, i++)
		if(m & 1) {
		    switch(i) {
			case background_pixmap:
			  {
			   if(((((value_t *)temp)->value) == 0) || ((((value_t *)temp)->value) == 1));
			   else
			    ((value_t *)foo)->value = map_ids(s, ((value_t *)temp)->value);
			  }
			  break;
			case border_pixmap:
			  {
			   if(((value_t *)temp)->value == 0);
			   else
			    ((value_t *)foo)->value = 
			       map_ids(s, ((value_t *)temp)->value);
			  }
			  break;
			case event_mask:
			  /* send the event mask to the slave servers
			     as it from the client */
			  /* {
			   if(((value_t *)temp)->value == 0);
			   else 
			       ((value_t *)foo)->value = 0;
			  } */
			  break;
			case colormap:
			  {
			   if(((value_t *)temp)->value == 0);
			   else {
			       ((value_t *)foo)->value = 
			          map_ids(s, ((value_t *)temp)->value);
			   }
			  }
			  break;
			case Cursor:
			  {
			   if(((value_t *)temp)->value == 0);
			   else {
			       ((value_t *)foo)->value = 
			          map_ids(s, ((value_t *)temp)->value);
			   }
			  }
			  break;
		    }
		    foo = foo + sizeof(value_t);
		    temp = temp + sizeof(value_t);
	       }
	}
	break;

	/* opcode 2 */
	case X_ChangeWindowAttributes:
	{
	    ((xChangeWindowAttributesReq *)foo)->window = 
	      map_ids(s, ((xChangeWindowAttributesReq *)temp)->window);

	    foo = foo + sz_xChangeWindowAttributesReq;
	    temp = temp + sz_xChangeWindowAttributesReq;
	    /* check for the values in the mask */
	    for(i = 0, m = ((xChangeWindowAttributesReq *)data)->valueMask; m; m = m >> 1, i++) {
		if(m & 1) {
		    switch(i) {
			case background_pixmap:
			  {
			   if(((((value_t *)temp)->value) == 0) || ((((value_t *)temp)->value) == 1));
			   else
			    ((value_t *)foo)->value = map_ids(s, ((value_t *)temp)->value);
			  }
			  break;
			case border_pixmap:
			  {
			   if(((value_t *)temp)->value == 0);
			   else
			    ((value_t *)foo)->value = 
			       map_ids(s, ((value_t *)temp)->value);
			  }
			  break;
			case event_mask:
			  /* send the event mask to the slave servers
			     as it from the client */
			  /* {
			   if(((value_t *)temp)->value == 0);
			   else
			       ((value_t *)foo)->value = 0;
			  } */
			  break;
			case colormap:
			  {
			   if(((value_t *)temp)->value == 0);
			   else {
			       ((value_t *)foo)->value = 
			      map_ids(s, ((value_t *)temp)->value);
			   }
			  }
			  break;
			case Cursor:
			  {
			   if(((value_t *)temp)->value == 0);
			   else {
			   ((value_t *)foo)->value = 
			      map_ids(s, ((value_t *)temp)->value);
			   }
			  }
			  break;
		    }
		    foo = foo + sizeof(value_t);
		    temp = temp + sizeof(value_t);
	       }
	   }
	}
	break;

	/* opcode 4 */
	case X_DestroyWindow:
	  ((xResourceReq *)foo)->id = map_ids(s, ((xResourceReq *)temp)->id);
	  break;

	/* opcode 5 */
	case X_DestroySubwindows:
	  ((xResourceReq *)foo)->id = map_ids(s, ((xResourceReq *)temp)->id);
	  break;

	/* opcode 6 */
	case X_ChangeSaveSet:
	{
	  ((xChangeSaveSetReq *)foo)->window = 
	    map_ids(s, ((xChangeSaveSetReq *)temp)->window);
	}
	break;

	/* opcode 7 */
	case X_ReparentWindow:
	{
	  ((xReparentWindowReq *)foo)->window = 
	    map_ids(s, ((xReparentWindowReq *)temp)->window);
	  ((xReparentWindowReq *)foo)->parent = 
	    map_ids(s, ((xReparentWindowReq *)temp)->parent);
	}
	break;

	/* opcode 8 */
	case X_MapWindow:
	   {
	     ((xResourceReq *)foo)->id = map_ids(s,((xResourceReq *)temp)->id);
	   }
	   break;

	/* opcode 9 */
	case X_MapSubwindows:
	   {
	     ((xResourceReq *)foo)->id = map_ids(s,((xResourceReq *)temp)->id);
	   }
	   break;

	/* opcode 10 */
	case X_UnmapWindow:
	{
	     ((xResourceReq *)foo)->id = map_ids(s,((xResourceReq *)temp)->id);
	}
	break;

	/* opcode 11 */
	case X_UnmapSubwindows:
	{
	     ((xResourceReq *)foo)->id = map_ids(s,((xResourceReq *)temp)->id);
	}
	break;

	/* opcode 12 */
	case X_ConfigureWindow:
	   {
	     ((xConfigureWindowReq *)foo)->window =
	       map_ids(s, ((xConfigureWindowReq *)temp)->window);
	   }
	   break;

	/* opcode 13 *
	case X_CirculateWindow:
	{
	  ((xCirculateWindowReq *)foo)->window =
	    map_ids(s, ((xCirculateWindowReq *)temp)->window);
	}
	break;

	/* opcode 16 */
	case X_InternAtom:
	   break;

	/* opcode 18 */
	case X_ChangeProperty:
	    ((xChangePropertyReq *)foo)->window =
	       map_ids(s, ((xChangePropertyReq *)temp)->window);
	    ((xChangePropertyReq *)foo)->property =
	       map_atoms(atoms, ((xChangePropertyReq *)temp)->property, slv_fd);
	    ((xChangePropertyReq *)foo)->type =
	       map_atoms(atoms, ((xChangePropertyReq *)temp)->type, slv_fd);

	    break;

	/* opcode 41 */
	case X_WarpPointer:
	{
	  ((xWarpPointerReq *)foo)->dstWid = 
	    map_ids(s, ((xWarpPointerReq *)temp)->dstWid);
	  if((((xWarpPointerReq *)temp)->srcWid) == 0);
	  else {
	    ((xWarpPointerReq *)foo)->srcWid = 
	      map_ids(s, ((xWarpPointerReq *)temp)->srcWid);
	  }
	}
	break;

	/* opcode 45 */
	case X_OpenFont:
	   {
	     ((xOpenFontReq *)foo)->fid = 
		map_ids(s, ((xOpenFontReq *)temp)->fid);
	   }
	   break;

	/* opcode 46 */
	case X_CloseFont:
	{
	  ((xResourceReq *)foo)->id = 
	    map_ids(s, ((xResourceReq *)temp)->id);
	  /* add_garbage_list(s, ((xResourceReq *)temp)->id); */
	  /* remove_entry(((xResourceReq *)temp)->id); */
	  /* printf("the font id to be closed is %ld \n", ((xResourceReq *)temp)->id); */
	  mark_entry(((xResourceReq *)temp)->id);
	}
	break;

	/* opcode 51 */
	case X_SetFontPath:
	  break;

	/* opcode 53 */ 
	case X_CreatePixmap:
	   {
	     ((xCreatePixmapReq *)foo)->pid = 
	       map_ids(s, ((xCreatePixmapReq *)temp)->pid);
	     ((xCreatePixmapReq *)foo)->drawable = 
	       map_ids(s, ((xCreatePixmapReq *)temp)->drawable);
	   }
	   break;

	/* opcode 54 */
	case X_FreePixmap:
	   {
	     ((xResourceReq *)foo)->id = map_ids(s, ((xResourceReq *)temp)->id);
	     /* add_garbage_list(s, ((xResourceReq *)temp)->id); */
	     /* remove_entry(((xResourceReq *)temp)->id); */
	  /* printf("the pixmap to be closed is %ld \n", ((xResourceReq *)temp)->id); */
	     mark_entry(((xResourceReq *)temp)->id);
	   }
	   break;

	/* opcode 55 */
	case X_CreateGC:
	   {
	     ((xCreateGCReq *)foo)->gc = map_ids(s, ((xCreateGCReq *)temp)->gc);
	     ((xCreateGCReq *)foo)->drawable = 
	       map_ids(s, ((xCreateGCReq *)temp)->drawable);
	     foo = foo + sz_xCreateGCReq;
	     temp = temp + sz_xCreateGCReq;
	     /* check for the values in the mask */
	     for(i = 0, m = ((xCreateGCReq *)data)->mask; m; m>>= 1, i++) {
		if(m & 1) {
		    switch(i) {
		      case tile:
		      {
			((value_t *)foo)->value = 
			  map_ids(s, ((value_t *)temp)->value);
		      }
		      break;
		      case stipple:
		      {
			((value_t *)foo)->value = 
			   map_ids(s, ((value_t *)temp)->value);
		      }
		      break;
		      case Font:
			((value_t *)foo)->value = map_ids(s, ((value_t *)temp)->value);
		      break;
		      case clip_mask:
		      {
			if(((value_t *)temp)->value == 0);
			else 
			  ((value_t *)foo)->value = map_ids(s, ((value_t *)temp)->value);
		      }
		      break;
		    }
		    foo = foo + sizeof(CARD32);
		    temp = temp + sizeof(CARD32);
		}
	     }
	   }
	   break;

	/* opcode 56 */
	case X_ChangeGC:
	{
	     ((xChangeGCReq *)foo)->gc = map_ids(s, ((xChangeGCReq *)temp)->gc);
	     foo = foo + sz_xChangeGCReq;
	     temp = temp + sz_xChangeGCReq;
	     /* check for the values in the mask */
	     for(i = 0, m = ((xChangeGCReq *)data)->mask; m; m>>= 1, i++) {
		if(m & 1) {
		    switch(i) {
		      case tile:
		      {
			((value_t *)foo)->value = 
			  map_ids(s, ((value_t *)temp)->value);
		      }
		      break;
		      case stipple:
		      {
			((value_t *)foo)->value = 
			   map_ids(s, ((value_t *)temp)->value);
		      }
		      break;
		      case Font:
			((value_t *)foo)->value = map_ids(s, ((value_t *)temp)->value);
		      break;
		      case clip_mask:
		      {
			if(((value_t *)temp)->value == 0);
			else 
			  ((value_t *)foo)->value = map_ids(s, ((value_t *)temp)->value);
		      }
		      break;
		    }
		    foo = foo + sizeof(CARD32);
		    temp = temp + sizeof(CARD32);
		}
	     }
	   }
	   break;

	/* opcode 57 */
	case X_CopyGC:
	{
	     ((xCopyGCReq *)foo)->srcGC = 
	       map_ids(s, ((xCopyGCReq *)temp)->srcGC);
	     ((xCopyGCReq *)foo)->dstGC = 
	       map_ids(s, ((xCopyGCReq *)temp)->dstGC);
	}
	   break;

	/* opcode 58 */
	case X_SetDashes:
	{
	  ((xSetDashesReq *)foo)->gc = map_ids(s, ((xSetDashesReq *)temp)->gc);
	}
	break;

	/* opcode 59 */
	case X_SetClipRectangles:
	{
	  ((xSetClipRectanglesReq *)foo)->gc = 
	    map_ids(s, ((xSetClipRectanglesReq *)temp)->gc);
	}
	break;

	/* opcode 60 */
	case X_FreeGC:
	   {
	     ((xResourceReq *)foo)->id = map_ids(s, ((xResourceReq *)temp)->id);
	     /* add_garbage_list(s, ((xResourceReq *)temp)->id); */
	     /* remove_entry(((xResourceReq *)temp)->id); */
	  /* printf("the GC to be closed is %ld \n", ((xResourceReq *)temp)->id); */
	     mark_entry(((xResourceReq *)temp)->id);
	   }
	   break;

	/* opcode 61 */
	case X_ClearArea:
	{
	  ((xClearAreaReq *)foo)->window = 
	    map_ids(s, ((xClearAreaReq *)temp)->window);
	}
	    break;

	/* opcode 62 */
	case X_CopyArea:
	{
	  ((xCopyAreaReq *)foo)->srcDrawable = 
	    map_ids(s, ((xCopyAreaReq *)temp)->srcDrawable);
	  ((xCopyAreaReq *)foo)->dstDrawable = 
	    map_ids(s, ((xCopyAreaReq *)temp)->dstDrawable);
	  ((xCopyAreaReq *)foo)->gc = 
	    map_ids(s, ((xCopyAreaReq *)temp)->gc);
	}
	    break;

	/* opcode 63 */
	case X_CopyPlane:
	{
	  ((xCopyPlaneReq *)foo)->srcDrawable = 
	    map_ids(s, ((xCopyPlaneReq *)temp)->srcDrawable);
	  ((xCopyPlaneReq *)foo)->dstDrawable = 
	    map_ids(s, ((xCopyPlaneReq *)temp)->dstDrawable);
	  ((xCopyPlaneReq *)foo)->gc = 
	    map_ids(s, ((xCopyPlaneReq *)temp)->gc);
	}
	    break;

	/* opcode 64 */
	case X_PolyPoint:
	{
	  ((xPolyPointReq *)foo)->drawable = 
	    map_ids(s, ((xPolyPointReq *)temp)->drawable);
	  ((xPolyPointReq *)foo)->gc = 
	    map_ids(s, ((xPolyPointReq *)temp)->gc);
	}
	  break;

	/* opcode 65 */
	case X_PolyLine:
	   {
	     ((xPolyLineReq *)foo)->drawable = 
	       map_ids(s, ((xPolyLineReq *)temp)->drawable);
	     ((xPolyLineReq *)foo)->gc = map_ids(s, ((xPolyLineReq *)temp)->gc);
	   }
	   break;

	/* opcode 66 */
	case X_PolySegment:
	   {
	     ((xPolySegmentReq *)foo)->drawable = 
	       map_ids(s, ((xPolySegmentReq *)temp)->drawable);
	     ((xPolySegmentReq *)foo)->gc = 
	       map_ids(s, ((xPolySegmentReq *)temp)->gc);
	   }
	   break;

	 /* opcode 67 */
	 case X_PolyRectangle:
	 {
	  ((xPolySegmentReq *)foo)->drawable = 
	    map_ids(s, ((xPolySegmentReq *)temp)->drawable);
	  ((xPolySegmentReq *)foo)->gc = 
	    map_ids(s, ((xPolySegmentReq *)temp)->gc);
	 }
	  break;
	/* opcode 68 */
	case X_PolyArc:
	{
	  ((xPolySegmentReq *)foo)->drawable = 
	    map_ids(s, ((xPolySegmentReq *)temp)->drawable);
	  ((xPolySegmentReq *)foo)->gc = 
	    map_ids(s, ((xPolySegmentReq *)temp)->gc);
	}
	  break;

	/* opcode 69 */
	case X_FillPoly:
	   {
	     ((xFillPolyReq *)foo)->drawable = 
	       map_ids(s, ((xFillPolyReq *)temp)->drawable);
	     ((xFillPolyReq *)foo)->gc = map_ids(s, ((xFillPolyReq *)temp)->gc);
	   }
	   break;

	/* opcode 70 */
	case X_PolyFillRectangle:
	{
	  ((xPolySegmentReq *)foo)->drawable = 
	    map_ids(s, ((xPolySegmentReq *)temp)->drawable);
	  ((xPolySegmentReq *)foo)->gc = 
	    map_ids(s, ((xPolySegmentReq *)temp)->gc);
	  break;
	}
	/* opcode 71 */
	case X_PolyFillArc:
	{
	  ((xPolySegmentReq *)foo)->drawable = 
	    map_ids(s, ((xPolySegmentReq *)temp)->drawable);
	  ((xPolySegmentReq *)foo)->gc = 
	    map_ids(s, ((xPolySegmentReq *)temp)->gc);
	}
	  break;

	/* opcode 72 */
	case X_PutImage:
	   {
	     ((xPutImageReq *)foo)->drawable = 
	       map_ids(s, ((xPutImageReq *)temp)->drawable);
	     if(((xPutImageReq *)foo)->drawable == 0)
	       return 0;
	     ((xPutImageReq *)foo)->gc = map_ids(s, ((xPutImageReq *)temp)->gc);
	     if(((xPutImageReq *)foo)->gc == 0)
	       return 0;
	   }
	   break;

	/* opcode 74 */
	case X_PolyText8:
	  {
	    ((xPolyTextReq *)foo)->drawable = 
	      map_ids(s, ((xPolyTextReq *)temp)->drawable);
	    ((xPolyTextReq *)foo)->gc = 
	      map_ids(s, ((xPolyTextReq *)temp)->gc);
	  }
	  break;

	/* opcode 75 */
	case X_PolyText16:
	  {
	    ((xPolyTextReq *)foo)->drawable = 
	      map_ids(s, ((xPolyTextReq *)temp)->drawable);
	    ((xPolyText16Req *)foo)->gc = 
	      map_ids(s, ((xPolyText16Req *)temp)->gc);
	  }
	  break;

	/* opcode 76 */
	case X_ImageText8:
	  {
	    ((xImageTextReq *)foo)->drawable =
	      map_ids(s, ((xImageTextReq *)temp)->drawable);
	    ((xImageTextReq *)foo)->gc =
	      map_ids(s, ((xImageTextReq *)temp)->gc);
	  }
	  break;

	/* opcode 77 */
	case X_ImageText16:
	  {
	    ((xImageTextReq *)foo)->drawable =
	      map_ids(s, ((xImageTextReq *)temp)->drawable);
	    ((xImageTextReq *)foo)->gc =
	      map_ids(s, ((xImageTextReq *)temp)->gc);
	  }
	  break;

	/* opcode 78 */
	case X_CreateColormap:
	{
	  ((xCreateColormapReq *)foo)->mid =
	    map_ids(s, ((xCreateColormapReq *)temp)->mid);
	  ((xCreateColormapReq *)foo)->window =
	    map_ids(s, ((xCreateColormapReq *)temp)->window);
	  ((xCreateColormapReq *)foo)->visual =
	    map_ids(s, ((xCreateColormapReq *)temp)->visual);
	}
	break;

	/* opcode 79 */
	case X_FreeColormap:
	  {
	     ((xFreeColorsReq *)foo)->cmap = 
	       map_ids(s, ((xFreeColorsReq *)temp)->cmap);
	     /* add_garbage_list(s, ((xFreeColorsReq *)temp)->cmap); */
	     /* remove_entry(((xFreeColorsReq *)temp)->cmap); */
	  /* printf("the cmap to be closed is %ld \n", 
	  ((xFreeColorsReq *)temp)->cmap); */
	     mark_entry(((xFreeColorsReq *)temp)->cmap);
	  }
	  break;

	/* opcode 80 */
	case X_CopyColormapAndFree:
	  {
	    ((xCopyColormapAndFreeReq *)foo)->mid = 
	      map_ids(s, ((xCopyColormapAndFreeReq *)temp)->mid);
	    ((xCopyColormapAndFreeReq *)foo)->srcCmap = 
	      map_ids(s, ((xCopyColormapAndFreeReq *)temp)->srcCmap);
	  }
	  break;
	/* opcode 81 */
	case X_InstallColormap:
	  ((xResourceReq *)foo)->id = map_ids(s, ((xResourceReq *)temp)->id);
	  break;

	/* opcode 82 */
	case X_UninstallColormap:
	  ((xResourceReq *)foo)->id = map_ids(s, ((xResourceReq *)temp)->id);
	  break;

	/* opcode 84 */
	case X_AllocColor:
	{
	  ((xAllocColorReq *)foo)->cmap = map_ids(s, ((xAllocColorReq *)temp)->cmap);
	}
	    break;

	/* opcode 85 */
	case X_AllocNamedColor:
	{
	  ((xAllocNamedColorReq *)foo)->cmap =
	    map_ids(s, ((xAllocNamedColorReq *)temp)->cmap);
	}
	break;

	/* opcode 86 */
	case X_AllocColorCells:
	{
	  ((xAllocColorCellsReq *)foo)->cmap =
	    map_ids(s, ((xAllocColorCellsReq *)temp)->cmap);
	}
	break;

	/* opcode 87 */
	case X_AllocColorPlanes:
	  {
	    ((xAllocColorPlanesReq *)foo)->cmap =
	      map_ids(s, ((xAllocColorPlanesReq *)temp)->cmap);
	  }
	  break;
	/* opcode 88 */
	case X_FreeColors:
	  {
	    ((xFreeColorsReq *)foo)->cmap = 
	      map_ids(s, ((xFreeColorsReq *)temp)->cmap);
	  }
	  break;
	/* opcode 89 */
	case X_StoreColors:
	  {
	    ((xStoreColorsReq *)foo)->cmap = 
	      map_ids(s, ((xStoreColorsReq *)temp)->cmap);
	  }
	  break;
	/* opcode 90 */
	case X_StoreNamedColor:
	  {
	    ((xStoreNamedColorReq *)foo)->cmap = 
	      map_ids(s, ((xStoreNamedColorReq *)temp)->cmap);
	  }
	  break;

	/* opcode 93 */
	case X_CreateCursor:
	{
	  ((xCreateCursorReq *)foo)->cid = 
	    map_ids(s, ((xCreateCursorReq *)temp)->cid);
	  ((xCreateCursorReq *)foo)->source = 
	    map_ids(s, ((xCreateCursorReq *)temp)->source);
	  ((xCreateCursorReq *)foo)->mask = 
	    map_ids(s, ((xCreateCursorReq *)temp)->mask);
	}
	  break;

	/* opcode 94 */
	case X_CreateGlyphCursor:
	{
	     ((xCreateGlyphCursorReq *)foo)->cid = 
	       map_ids(s, ((xCreateGlyphCursorReq *)temp)->cid);
	     ((xCreateGlyphCursorReq *)foo)->source =
	       map_ids(s, ((xCreateGlyphCursorReq *)temp)->source);
	     if((((xCreateGlyphCursorReq *)data)->mask) == 0);
	     else {
	       ((xCreateGlyphCursorReq *)foo)->mask = 
		 map_ids(s, ((xCreateGlyphCursorReq *)temp)->mask);
	     }
	}
	   break;

	/* opcode 95 */
	case X_FreeCursor:
	{
	  ((xResourceReq *)foo)->id = map_ids(s, ((xResourceReq *)temp)->id);
	  /* add_garbage_list(s, ((xResourceReq *)temp)->id); */
	  /* remove_entry(((xResourceReq *)temp)->id); */
	  mark_entry(((xResourceReq *)temp)->id);
	}
	break;

	/* opcode 96 */
	case X_RecolorCursor:
	  {
	     ((xRecolorCursorReq *)foo)->cursor = map_ids(s,((xRecolorCursorReq *)temp)->cursor);
	  }
	  break;

	/* opcode 104 */
	case X_Bell:
	  break;

	/* opcode 105 */
	case X_ChangePointerControl:
	  break;
	  
	/* opcode 107 */
	case X_SetScreenSaver:
	  break;

	/* opcode 109 */
	case X_ChangeHosts:
	  break;

	/* opcode 111 */
	case X_SetAccessControl:
	  break;

	/*opcode 114 */
	case X_RotateProperties:
	{
	  ((xRotatePropertiesReq *)foo)->window =
	    map_ids(s, ((xRotatePropertiesReq *)temp)->window);
	}
	break;

	/* opcode 115 */
	case X_ForceScreenSaver:
	  break;

	/* opcode 116 */
	case X_SetPointerMapping:
	  break;

	/* opcode 118 */
	case X_SetModifierMapping:
	  break;

	/* opcode 127 */
	case X_NoOperation:
	   break;
    }
}

void
init_buff(buff)
char *buff;
{
    int i;

    for (i = 0; i<1000; i++)
	buff[i] = 0;
}
