#include<sys/types.h>
#include<sys/socket.h>
#include "xmx.h"
#include<X11/X.h> 
#include<sys/un.h>

#define NEED_REPLIES

/* 
 **************************************************************************
 * Structure Definitions 
 **************************************************************************
 */

typedef struct _window {
    CARD32 		wid;
    CARD32 		cmap;
    CARD32 		visual_id;
    int			x, y;
    unsigned int 	white_pixel, black_pixel;
    struct _window *	parent;
    struct _window *	left_sibling;
    struct _window *	right_sibling;
    struct _window *	child;
    struct _window *	next;
}window;

/*
 **************************************************************************
 * Function Definitions
 **************************************************************************
 */
void relate_windows(window *wn, window *wp);

/* global variables */
static window *root_win = (window *)0;

/*
 ************************************************************************
 * Add new window in the list of windows
 ************************************************************************
 */

add_new_window(s, wid, cmap, visual_id, white_pixel, black_pixel)
int s;
CARD32 wid, cmap, visual_id, white_pixel, black_pixel;
{
    window *wn, *foo;

    if(!root_win) {
	wn = root_win = (window *)malloc(sizeof(window));
	if( root_win == 0)
	    quit(1, "ERROR: out of space\n");
    }

    else {
	for(foo = root_win; foo->next; foo = foo->next);
	wn = foo->next = (window *)malloc(sizeof(window));
	if(wn == 0)
	    quit(1, "ERROR: out of space\n");
    }

    wn->wid = wid;
    wn->cmap = cmap;
    wn->x = 0;
    wn->y = 0;
    wn->parent = (window *)0;
    wn->visual_id = visual_id;
    wn->white_pixel = white_pixel;
    wn->black_pixel = black_pixel;
    wn->next = (window *)0;

    add_map_server_id(s, wid, (char *)wn);
    add_map_server_id(s, cmap, (char *)0);
}

/*
 ************************************************************************
 * map ids of the request from the client to the master server
 ************************************************************************
 */

int
process_request(data, s, atoms, seq_no)
char *data;
int s;
ATOM **atoms;
int seq_no;
{
    char *data_temp;
    window *wn, *parent;
    xReq *req;

    data_temp = data;
    req = (xReq *)data;
    /* keep count off the requests received to store the sequence number */
    switch(req->reqType) {
	/* opcode 1 */
	case X_CreateWindow:
	    {
	        register xCreateWindowReq * win_req = (xCreateWindowReq *)data;
	        parent = (window *)get_rid_data(win_req->parent);
		if(parent == 0)
		    return 0;
		wn = (window *)malloc(sizeof(window));
		if(wn == 0)
		    quit(1, "ERROR: out of space\n");
		wn->wid = win_req->wid;
		wn->x = parent->x + win_req->x;
		wn->y = parent->y + win_req->y;
		/* IT (relate_windows) WAS NOT INCLUDED */
		/* relate_windows(parent, wn); */
		add_map_rid(wn->wid, (char *)wn, s);
	    }
	    break;
	/* opcode 8 */
	case X_MapWindow:
	    {
	/*	register xResourceReq *map = (xResourceReq *)data; */
	    }
	    break;
	/* opcode 9 */
	case X_MapSubwindows:
	    {
		/* register xResourceReq *map = (xResourceReq *)data; */
	    }
	    break;
	case X_InternAtom:
	    {
		register xInternAtomReq *atom_req = (xInternAtomReq *)data;
		add_seq_no(seq_no, atoms);
	    }
	/* opcode 20 */
	case X_GetProperty:
	    {
		/* register xGetPropertyReq *req = (xGetPropertyReq *)data; */
	    }
	    break;
	/* opcode 45 */
	case X_OpenFont:
	    {
		register xOpenFontReq *font = (xOpenFontReq *)data;
		add_map_rid(font->fid, (char *)0, s);
	    }
	    break;
	/* opcode 53 */
	case X_CreatePixmap:
	    {
		register xCreatePixmapReq *pmap = (xCreatePixmapReq *)data;
		add_map_rid(pmap->pid, (char *)0, s);
	    }
	    break;
	/* opcode 55 */
   	case X_CreateGC:
	    {
		register xCreateGCReq *gc = (xCreateGCReq *)data;
		add_map_rid(gc->gc, (char *)0, s);
	    }
	    break;

	/* opcode 78 */
	case X_CreateColormap:
	{
	  register xCreateColormapReq *map = (xCreateColormapReq *)data;
	  add_map_rid(map->mid, (char *)0, s);
	}
	break;

	/* opcode 80 */
	case X_CopyColormapAndFree:
	{
	  register xCopyColormapAndFreeReq *temp = (xCopyColormapAndFreeReq *)data;
	  add_map_rid(temp->mid, (char *)0, s);
	  }
	
	break;

	/* opcode 84 */
	case X_AllocColor:
	{
	  register xAllocColorReq *col = (xAllocColorReq *)data;
	  add_map_rid(col->cmap, (char *)0, s);
	}
	break;
	/* opcode 93 */
	case X_CreateCursor:
	{
	  register xCreateCursorReq *temp = (xCreateCursorReq *)data;
	  add_map_rid(temp->cid, (char *)0, s);
	}
	break;

	/* opcode 94 */
	case X_CreateGlyphCursor:
	    {
		register xCreateGlyphCursorReq *cur = (xCreateGlyphCursorReq *)data;
		add_map_rid(cur->cid, (char *)0, s);
	    }
	    break;

	/* opcode 98 */
        case X_QueryExtension:
	    {
		register xQueryExtensionReq *query_ext = (xQueryExtensionReq *)data;
	    }
	    break;
	}
	return 1;
}

int
process_reply(s, data)
int s;
char *data;
{


}
/*
 ***********************************************************************
 * Link the related windows
 ***********************************************************************
 */

/* void
relate_windows(parent, wn)
window *parent, *wn;
{
    wn->left_sibling = (window *)0;
    wn->right_sibling = parent->child;

    if(parent->child)
	parent->child->left_sibling = wn;
    parent->child = wn;
    wn->parent = parent;
} */
