
#define 	NEED_REPLIES
#include "xmx.h"
#define 	NEED_EVENTS
#include<X11/Xlib.h>
#include<X11/X.h>

/*
 *Function Definitions
 */
void adjust(struct buff_t *buff, int len);
int get_remaining_data(int sockfd, struct buff_t *buffer);
void init_buffer(struct buff_t *bp);
int read_socket(int sockfd, struct buff_t *buff, int nbytes);
int send_buff(int sockfd, struct buff_t *bp);
int send_bdcast(int, char *, int);
int send_pkt(int, char *, unsigned long);
void copy_buf(struct buff_t *bp_from, struct buff_t *bp_to);

extern unsigned long data_left, data;
extern char *packet;

/*
 *=========================================================================
 * Initialize the buffer
 *=========================================================================
 */

void
init_buffer(bp)
struct buff_t *bp;
{
    bp->active_data = 0;
    bp->size = 0;
    bp->foo = (char *)0;
}

void
init_slave_buff(bp)
buffer_t *bp;
{
    bp->n = 0;
    bp->size = 0;
    memset( (void *)bp->data, 0, MAX_BUFF_LEN);
}
/*
 *=========================================================================
 * Read the data from the socket and reallocate the memory if
 * needed
 *=========================================================================
 */

int
read_socket(sockfd, buff, nbytes)
int sockfd;
struct buff_t *buff;
int nbytes;
{
    int readn, nread;
    int nleft, t, r;
    char *foo;

    if(buff->active_data == 0) {
	buff->foo = (char *)malloc(nbytes);
	if (buff->foo == 0)
	    quit(1, "Error: out of space\n");
    }
    else
	adjust(buff, nbytes);
    nread = get_data(sockfd, buff, nbytes);
    if(nread == 0) {
	return 0;
    }
    buff->active_data = buff->active_data + nbytes;
    return buff->active_data;
}

/*
 *=========================================================================
 * Write the active data to the socket 
 *=========================================================================
 */

int
send_buff(sockfd, bp)
int sockfd;
struct buff_t *bp;
{
    int active_data;

    active_data = bp->active_data;
    if(writen(sockfd, bp, active_data) != active_data) {
	printf("error in writing data\n");
	return -1;
    }
    return 1;
}

/*
 *=========================================================================
 *call realloc() function to store remaining bytes of data
 *=========================================================================
 */

void
adjust(buff, len)
struct buff_t *buff;
int len;
{
    buff->foo = (char *)realloc(buff->foo, (buff->active_data + len));
    if(buff->foo == 0)
      quit(1, "ERROR out of space\n");
}

/*
 *=============================================================================
 * make a duplicate copy of the buffer 
 *=============================================================================
 */

void
copy_buf(bp_from, bp_to)
struct buff_t *bp_from;
struct buff_t *bp_to;
{
    bp_to->active_data = bp_from->active_data;
    bp_to->foo = bp_from->foo;
}

/* 
 *=============================================================================
 * This function reads the header from the socket, and puts it in the 
 * buffer_t structure and it returns the length of the message
 *=============================================================================
 */

/****
int
get_req(sockfd, buff, nbytes)
int sockfd;
struct buffer_t *buff;
int nbytes;
{
	int nread, nleft;
	int len;

	nleft = nbytes;
	while(nleft > 0) {
	printf("we are before the get read function\n");
	printf("the sockect id for cli is %d in the read function\n", sockfd);
		nread = read(sockfd, buff->header, nleft);
	printf("we are after the get read function\n");
		if(nread < 0)
			return nread;
		else if (nread == 0) 
			break;

		nleft = nleft - nread;
		if (nleft > 0)
			buff->header = buff->header + nread;
	}
	len = ((xReq *)buff->header)->length << 2;
	printf("The opcode in the readn fn is %d \n", ((xReq *)buff->header)->reqType);
	printf("The length in the readn fn is %d \n", ((xReq *)buff->header)->length);
	return len;
}
****/

/* 
 *=============================================================================
 * This function reads the data from the incomming socket 
 *=============================================================================
 */

int
get_data(sockfd, buff, nbytes)
int sockfd;
struct buff_t *buff;
int nbytes;
{
	int nread, nleft;
	char *foo;

	nleft = nbytes;
	foo = (char *)(buff->active_data + buff->foo);
	while(nleft > 0) {
		/****
		nread = read(sockfd, (char *)(buff->active_data + buff->foo), nleft);
		****/
		nread = read(sockfd, foo, nleft);
		if(nread < 0)
			return -1;
		else if (nread == 0)
		    break;

		nleft = nleft - nread;
		/****
		if (nleft > 0)
		****/
		foo = foo + nread;
	}
	return (nbytes - nleft);
}

/*
 *=============================================================================
 * This function writes nbytes to stream socket.
 *=============================================================================
 */

int
writen(sockfd, buff, len)
int sockfd;
struct buff_t *buff;
int len;
{
	int writen, nleft;
	nleft = len;

	while(nleft > 0) {
		writen = write(sockfd, buff->foo, nleft);
		if(writen <= 0)
			return writen;
		
		nleft = nleft - writen;
		buff->foo = buff->foo + writen;
	}

	return (len - nleft);
}

/* 
 * This function sends the requests to the master server and if some requests
 * in the packet are not fully received then it will append that part in the
 * packet
 */

send_pkt(sockfd, buff, len)
int sockfd;
char *buff;
unsigned long len;
{
    unsigned long t, i;
    unsigned long writen, nleft;
    nleft = len;
      t = data - len;
    while(nleft > 0) {
	writen = write(sockfd, buff, nleft);
	if(writen <= 0)
	    return writen;

	nleft = nleft - writen;
	buff = buff + writen;
    }
    if( len < data) {
      /****
      printf("we are in the append loop \n");
      ****/
      i = 0;
      while(i < t) {
	packet[i] = packet[i+len];
	i = i+1;
      }
      data_left = data - len;
    }
    else
      data_left = 0;
    return (len - nleft);
}

/***************************************************************************
* send the data to the master server and if there is some data left in after
* sending it, move that data to the begining of the buffer.
***************************************************************************/

send_reply(sockfd, buff, len)
int sockfd;
buffer_t *buff;
unsigned long len;
{
    unsigned long t, i;
    unsigned long writen, nleft;
    char *data;

    nleft = len;
    data = (char *)buff->data;
    t = buff->size + buff->n - len;
    while(nleft > 0) {
	writen = write(sockfd, data, nleft);
	if(writen <= 0)
	    return writen;

	nleft = nleft - writen;
	data = data + writen;
    }
    if( len < (buff->n + buff->size)) {
      printf("we are in the append loop \n");
      i = 0;
      while(i < t) {
	buff->data[i] = buff->data[i+len];
	i = i+1;
      }
      buff->n = (buff->size + buff->n) - len;
    }
    else
      buff->n = 0;
    return (len - nleft);
}

/* 
 *************************************************************************
 * this function broadcasts the messages to the slaves
 *************************************************************************
 */

int
send_bdcast(sockfd, buff, len)
int sockfd;
char *buff;
int len;
{
	int writen, nleft;

	nleft = len;
	while(nleft > 0) {
		writen = write(sockfd, buff, nleft);
		if(writen <= 0)
			return writen;
		
		nleft = nleft - writen;
		buff = buff + writen;
	}

	return (len - nleft);
}

/*
 *=============================================================================
 * Get the type of the reply and accordingly copy the contents of
 * remaining data(if any) to the buffer.msg.
 *=============================================================================
 */

int 
get_remaining_data(sockfd, buffer)
int sockfd;
struct buff_t *buffer;
{
	int length, packet_len;
	xGenericReply *reply = ((xGenericReply *)buffer->foo);

	switch(reply->type) {
		case X_Error:
			packet_len = sz_xError;
			break;
		case X_Reply:
			/* earlier it was 2 I made it 4 */
			length = (reply->length) * 4;
			packet_len = (reply->length * 4) + sz_xGenericReply;
			if(packet_len == sz_xGenericReply)
				break;
			/*eariler it was packet length now I made it to len */
			if(read_socket(sockfd, buffer, length) <0 ) {
				printf("error in read socket\n");
				return -1;
			}
			break;

		default:
			packet_len = sz_xEvent;
			break;
	}
	return packet_len;
}
