#include<sys/types.h>
#include<sys/socket.h>
#include "xmx.h"
#include<X11/X.h> 
#include<sys/un.h>

#define NEED_REPLIES
#define	MAX_NO_OF_SERVERS	50 /* maximum number of servers */
#define MAX_NO_OF_RIDS		2048 
#define hash(rid, table_size)	(rid%table_size)

extern Connection *conn_info_vector;

/*
 **************************************************************************
 * Function Definitions
 **************************************************************************
 */
void map_init(int s, CARD32 rid_mask, CARD32 rid_base);
void init();
void add_map_server_id(int s, CARD32 rid, char *data_ptr);

/* 
 **************************************************************************
 * Structure Definitions 
 **************************************************************************
 */

typedef struct _rmap_ids_t{
	int 		master;
	int		slave;
	int		is_slave;
	long		rid;
	long		sid;
	char *		data_ptr;
	int		mark;
	struct _rmap_ids_t *	next;
}rmap_ids_t;

typedef struct {
	long		rid_mask;
	long 		rid_base;
	int		right_zeros;
	rmap_ids_t *	map_ids;
}server;

typedef struct _garbage_t {
	rmap_ids_t *garbage_element;
	struct _garbage_t *next;
} garbage_t;

rmap_ids_t *get_prev(rmap_ids_t *, CARD32 rid);

static server **	servers;
static rmap_ids_t *	rmap_ids[MAX_NO_OF_SERVERS];
static int		master = -1;
static int 		no_of_servers = MAX_NO_OF_SERVERS;
/* static garbage_t *	start = (garbage_t *)0;	*/

/* 
 **************************************************************************
 * Initialize the server table to store the mapped enteries 
 **************************************************************************
 */
void
init()
{
    int i;

    servers = (server **)calloc(MAX_NO_OF_SERVERS, sizeof(server *));
    if(servers == 0)
	quit(1, "ERROR: no space\n");
    /* rmap_ids = (rmap_ids_t **)calloc(no_of_servers, sizeof(rmap_ids_t *));
    for(i = 0; i < no_of_servers; i++)
	rmap_ids[i] = (rmap_ids_t *)0; */
}

/*
 **************************************************************************
 *
 * Initialize the mapping table by entering the resource_id_mask
 * and resource_id_base elements returned by the server in the setup
 * information
 *
 **************************************************************************
 */

void
map_init(s, rid_mask, rid_base)
int s;
CARD32 rid_mask;
CARD32 rid_base;
{
    int i;
    if(master < 0)    
        master = s;
    
    if((servers[s] = (server *)malloc(sizeof(server))) == 0)
	quit(1, "error: out of space\n");

    for(i = 0; (rid_mask % 2) == 0; ++i);
    servers[s]->right_zeros = i;
    servers[s]->rid_mask = rid_mask;
    servers[s]->rid_base = rid_base;
/******
    printf("===============================================\n");
    printf("socetfd is %d \n", s);
    printf("number of right zeros in rid_mask are %d \n", i);
    printf("rid_mask is %l \n", rid_mask);
    printf("rid_base is %l \n", rid_base);
******/
    servers[s]->map_ids = (rmap_ids_t *)0;
}

/* 
 *************************************************************************
 * add the entry for a new resource id provided by the X server
 *************************************************************************
 */

void
add_map_server_id(s, rid, data_ptr)
int s;
CARD32 rid;
char *data_ptr;
{
    rmap_ids_t *mp;

    if ((mp = (rmap_ids_t *)malloc(sizeof(rmap_ids_t))) == 0)
	quit(1, "ERROR: out of space\n");

    mp->rid = rid;
    mp->sid = 0;
    mp->data_ptr = data_ptr;
    (rmap_ids_t *)mp->next = (rmap_ids_t *)servers[s]->map_ids;
    servers[s]->map_ids = mp;
}

/*
 *************************************************************************
 * add the entry for the resource id from the request sent by the client
 * to the server
 *************************************************************************
 */

void
add_map_rid(rid, data_ptr, s)
CARD32 rid;
char * data_ptr;
int s;
{
    int i, hash_index;
    rmap_ids_t *rp;
    static int sid;

    hash_index = hash(rid, no_of_servers);

    for(rp = rmap_ids[hash_index]; rp && rid != rp->rid; rp = rp->next); 
    if(rp);
	/* printf("warning: can not add duplicate entry\n"); */
    else {
        rp = (rmap_ids_t *)malloc(sizeof(rmap_ids_t));
	if(rp == 0)
	    quit(1, "ERROR: out of space\n");
        
	rp->master = s;
	rp->rid = rid;
	rp->sid = ++sid;
	rp->data_ptr = data_ptr;
	rp->mark = 0;
	rp->next = rmap_ids[hash_index];
	rmap_ids[hash_index] = rp;

    }
}

/*******************************************************************
 * Add the sequence number for a request in order to catch the replies
*******************************************************************/

add_seq_no( seq_no, atoms )
int seq_no;
ATOM **atoms;
{
    ATOM *am;

    am = (ATOM *)malloc(sizeof(ATOM));
    if(am == NULL) {
        printf( "ERROR out of space\n");
        exit(1);
    }
    am->seq_no = seq_no;
    am->next = *atoms;
    *atoms = am;
}
     

map_atoms( atoms, ms_atom, slv_fd )
ATOM *atoms;
long ms_atom;
int slv_fd;
{
    ATOM *am;

    for(am = atoms; am && atoms->master_atom_id != ms_atom; am = am->next);
    if( am )
	return atoms->slave_atom_ids[slv_fd];
    /****
    else 
	printf("Error: atom not found \n");
	****/

}

/* When client closes the connection with the multiplexer free all the memory 
 * associated with the atoms for that client
 */

void
free_atoms(atoms)
ATOM *atoms;
{
    ATOM *next, *cur;

    cur = atoms;
    while(cur) {
	next = cur->next;
	free((void *)cur);
	cur = next;
    }
}

/*
 ***********************************************************************
 * Get the data for the correspoding resource_id
 ***********************************************************************
 */

 char *
 get_rid_data(rid)
 CARD32 rid;
 {
     rmap_ids_t *rp;
     int hash_index;
     
     /* first look in table where initial information about the serves
      * is stored */
     for(rp = servers[master]->map_ids; rp && rid != rp->rid; rp = rp->next);
     if(rp)
	 return rp->data_ptr;

     hash_index = hash(rid, no_of_servers);
     for(rp = rmap_ids[hash_index]; rp && rid != rp->rid; rp = rp->next);

     if(rp)
	 return rp->data_ptr;
     else
	 return (char *)0;
}

/*
 ****************************************************************************
 *
 * map_ids:		map the ids before the request  is sent to slave
 *
 ****************************************************************************
 */

int
map_ids(s, rid)
int s;
CARD32 rid;
{
    rmap_ids_t *rp, *mp;
    int hash_index;
    CARD32 id;

    rp = servers[s]->map_ids;

    for(mp = servers[master]->map_ids; mp && rid != mp->rid; mp = mp->next)
	rp = rp->next;
    if(mp)
	return rp->rid;
    
    hash_index = hash(rid, no_of_servers);
    for(rp = rmap_ids[hash_index]; rp && rid != rp->rid; rp = rp->next);

    /* printf("rids to be mapped are %ld \n", rid); */
    if(!rp) {
	fprintf(stderr, "error: can not find the resource id.\n");
	return 0;
    }

    id = ((rp->sid << servers[s]->right_zeros)&(servers[s]->rid_mask))|servers[s]->rid_base;
    rp->slave = id;
    return id;
}

/*
 ************************************************************************
 * map the rids of the slave servers to the rids of the master server
 ************************************************************************
 */

int
map_ids_to_master(s, rid)
int s;
CARD32 rid;
{
    rmap_ids_t *rp, *mp;
    int hash_index, j;
    CARD32 id;

    rp = servers[master]->map_ids;

    for(mp = servers[s]->map_ids; mp && rid != mp->rid; mp = mp->next)
	rp = rp->next;
    if(mp)
	return rp->rid;
    
    for(j = 0; j < MAX_NO_OF_SERVERS; j++) {
      for(rp = rmap_ids[j]; rp; rp = rp->next) {
	 if(rid == rp->slave)
	   return rp->rid;
	 else
	   continue;
      }
    }

    if(!rp) {
	fprintf(stderr, "error: can not find the resource id.\n");
	return 0;
    }
}

/*
 ********************************************************************
 * Collect all the resource ids to free it later
 *********************************************************************
 */

/* void
add_garbage_list(s, rid)
int s;
CARD32 rid;
{
    rmap_ids_t *sp;
    garbage_t *gb;
    int hash_index;
    static int i = 0;
    
    hash_index = hash(rid, no_of_servers);
    for(sp = rmap_ids[hash_index]; sp && rid != sp->rid; sp = sp->next) {
      if(i == 0)
	rmap_ids[hash_index] = (rmap_ids_t *)0;
      else
        i++;
    }
    if(sp) {
        if(start == 0) {
	    gb = start = (garbage_t *)malloc(sizeof(garbage_t));
	    if (gb == 0) 
	       quit(1, "error: out of space\n");
        }
	else {
	    for(gb = start; gb->next ; gb = gb->next);
            gb = gb->next = (garbage_t *)malloc(sizeof(garbage_t));
            if (gb == 0) 
               quit(1, "error: out of space\n");
        }
	gb->garbage_element = sp;
	gb->next = (garbage_t *)0;
    }
} */

/*
 *************************************************************************
 * mark the enteries those are to be deleted
 *************************************************************************
 */

int
mark_entry(rid)
CARD32 rid;
{
    rmap_ids_t *rp;
    int hash_index;

    hash_index = hash(rid, no_of_servers);
    for(rp = rmap_ids[hash_index]; rp && rp->next; rp = rp->next) {
        if(rp->rid == rid) {
	    rp->mark = 1;
	    return 1;
        }
    }
    return 0;
}
	
/*
 ************************************************************************
 * delete all the marked enteries
 ************************************************************************
 */

void
remove_entry()
{
    rmap_ids_t *prev, *sp;
    int i, j;

    for(j = 0; j < MAX_NO_OF_SERVERS; j++) {
      for(i = 0, sp = rmap_ids[j]; sp; sp = sp->next, i++) {
	if(sp->mark) {
 	  /* if(rid == sp->rid) { */
	    if(sp->next == (rmap_ids_t *)0 && i ==0) {
		rmap_ids[j] = (rmap_ids_t *)0;
		free((char *)sp);
	    }
	    else if (sp == rmap_ids[j]) {
		rmap_ids[j] = sp->next;
		free((char *)sp);
	    }
	    else {
		prev = get_prev(rmap_ids[j], sp->rid);
		prev->next = sp->next;
		free((char *)sp);
	    }
	//}
      }
    }
  }
}

/*
 ***********************************************************************
 * This function is called to delete all the enteries related to a 
 * particular client 
 ***********************************************************************
 */

void
free_rids(s)
int s;
{
    rmap_ids_t *prev, *sp;
    int i, j;

    for(j = 0; j < MAX_NO_OF_SERVERS; j++) {
      for(i = 0, sp = rmap_ids[j]; sp; sp = sp->next, i++) {
	if(sp->master == s) {
 	  /* if(rid == sp->rid) { */
	    if(sp->next == (rmap_ids_t *)0 && i ==0) {
		rmap_ids[j] = (rmap_ids_t *)0;
		free((char *)sp);
	    }
	    else if (sp == rmap_ids[j]) {
		rmap_ids[j] = sp->next;
		free((char *)sp);
	    }
	    else {
		prev = get_prev(rmap_ids[j], sp->rid);
		prev->next = sp->next;
		free((char *)sp);
	    }
	//}
      }
    }
  }
}

/*
 ***********************************************************************
 * This routine is used to get the previous node of the node containing
 * resource id rid
 ***********************************************************************
 */

rmap_ids_t *
get_prev(start, rid)
rmap_ids_t *start;
CARD32 rid;
{
    rmap_ids_t *s;
    for(s = start; s->next && (s->next)->rid != rid; s = s->next);
    if(s->next)
	return (rmap_ids_t *)s;
}

/*
 **************************************************************************
 * free the memory allocated by structures
 ***************************************************************************
 */

void
free_garbage(s)
int s;
{
    rmap_ids_t *rp, *next;
    int i, j;

    for(next = rp = servers[s]->map_ids; rp; next = rp) {
	rp = rp->next;
	free((char *)next);
    }
    free((char *)servers[s]);
    servers[s] = (server *)0;

    /* free the memory allocated by the servers to map resource ids */
    /* for(j = 0; j < MAX_NO_OF_SERVERS; j++) {
     if(rmap_ids[j]){
      for(next = rp = rmap_ids[j]; rp; next = rp) {
       rp = rp->next;
       free((char *)rp);
      }
    }
    else continue;
  }
  for(i = 0; i < no_of_servers; i++)
    rmap_ids[i] = (rmap_ids_t *)0; */
}
