#define NEED_REPLIES
#include"xmx.h"
#include<X11/X.h>
#include<pwd.h>
#ifdef __SVR4
#include<string.h>
#else
#include<strings.h>
#endif

#define MAXSIZE         30
#define MAXNOOFSERVERS  5
#define TABLE_SIZE  	20

/*
 *==========================================================================
 * Function definitions
 *==========================================================================
 */

int getNames(int , char **, char**);
void set_fds(int fd, short int type, fd_set *savefds);
void broadcast(Slv *, int, char *, int, ATOM *);
void close_conn(int fd, fd_set *savefds);

/*
 *==========================================================================
 * Global variables
 *==========================================================================
 */

Connection *conn_info_vector;
int max_fd = -1;
static master = -1;
static int slaves = 0;
static char **namelist;
int max_len = 2000000;
char * packet;
unsigned long data, data_left;
int no_of_names;

main(argc, argv)
int argc;
char *argv[];
{
    int ret, n, packet_len;
    int s, u, j, k;
    unsigned long t, l;
    int master_fd, sockfd, fd;
    int temp;
    fd_set readfds, savefds;
    int *arr_of_file_ids;
    Display_t master, slv;
    struct buff_t *rp, reply;
    char *cli;
    struct timeval *timeout = NULL;
    int display_no, screen_no;
    int i, fd_counter, no_of_fds;
    int fd_array[100];
    char *slave = 0;

    fd_counter = 0;
    no_of_fds = 0;
    display_no = screen_no = 0;
    if(argc > 2) {
        if(strcmp(argv[1], "-s") == 0) {
	    namelist = (char **)malloc(MAXNOOFSERVERS);
	    no_of_names = getNames(argc, namelist, argv);
	}
	else { 
	    printf(" Invalid Command \n");
	    exit(1);
	}
	}
    else {
        printf(" Invalid Command \n");
        exit(1);
    }

    conn_info_vector = (Connection *)calloc(TABLE_SIZE, sizeof(Connection));
    init();
    FD_ZERO(&savefds);
    /*****
    for(i = 0; i < no_of_names; i++) {
        if((sockfd = open_display(namelist[i], display_no, &buff)) <0){
	    if(i == 0) {
   		fprintf(stderr, "cannot connect to the master X server
			%s \n", namelist[i]);
		exit(1);
	    }
            else {
		printf("Warning: cannot connect to the : %s server \n", 
		   namelist[i]);
		continue;
	    }
	}
	if(i == 0) {
	    set_fds(sockfd, MASTER, &savefds);
	    master.screen = screen_no;
	    master.display = display_no;
	    master.hostname = namelist[i];
	    master_fd = sockfd;
	}
	else {
	    set_fds(sockfd, SLAVE, &savefds);
	    slv.hostname = namelist[i];
	    ++slaves;
	}
    }
    *****/
    if((fd = open_conn_with_client()) < 0)
	exit(1);

    set_fds(fd, CONNECT, &savefds);

    for(; ;) {
      memcpy((void *)&readfds, (void *)&savefds, sizeof(fd_set));
      ret = select((max_fd + 1), (fd_set *)&readfds, (fd_set *)0,(fd_set *)0, timeout);
      if(ret < 0) {
	perror("select");
	exit(1);
      }

      else if(ret == 0)
	continue;
      for( i = 0; i <= max_fd; i++) {
   	if(FD_ISSET(i, &readfds)) {
	  switch(conn_info_vector[i].type) {
				
	/* handle the connection request from a client */
	    case CONNECT:
	    {
	      struct buff_t buff;
	      struct buff_t  slv;
	      char *temp_name;

	      int temp_fd;
	      if((fd = accept_conn(i)) < 0)
	        continue;
	      if((temp = test_conn_request(fd)) < 0)
	        continue;
	      set_fds(fd, CLIENT, &savefds);
	      buff;
	      temp_name = (char *)namelist[2];
	      n = open_display(namelist[0], display_no, &buff);
	      namelist[2] = temp_name;
	      if( n < 0 ) {
	        close_conn(fd, &savefds);
		printf( " ERROR: client is not allowed to connect to server\n");
		exit(1);
	      }

	      master.screen = screen_no;
	      master.display = display_no;
	      master.hostname = namelist[0];
	      master_fd = sockfd;
	      conn_info_vector[n].u.master.mate = fd;
	      set_fds(n, MASTER, &savefds);
	      conn_info_vector[fd].u.client.mate = n;
	      conn_info_vector[fd].u.client.atoms = (ATOM *)0;
	      conn_info_vector[fd].u.client.seq_no = 0;
	      /* sid variable is added to calculate unique resource ID
		for each passive server for a client. */
	      /* conn_info_vector[fd].u.client.sid = 0; */
	      init_slave_buff( &(conn_info_vector[n].u.master.buff) );
	      /* if(slaves) */
	      for(j=0,k=1;k<no_of_names;j++,k++) {
		if((n=open_display(namelist[k], display_no, &slv)) < 0) {
	          conn_info_vector[fd].u.client.slv[j].mark = 0;
		  printf("WARNING: Client is not authorized to connect to %s server\n", namelist[k]);
		  continue;
		}
		/* keep count of total number of slaves */
	        ++slaves;
		conn_info_vector[fd].u.client.slv[j].mark = 1;
		conn_info_vector[fd].u.client.slv[j].slave = n;
		conn_info_vector[n].u.slave.client_mate = fd;
	        init_slave_buff( &(conn_info_vector[n].u.slave.buff) );
		set_fds(n, SLAVE, &savefds);
	      }
	      if(j > slaves)
	        slaves = j;

	      /* send the connection setup information to the client */
	      if(send_buff(fd, &buff) < 0) {
	        close_conn(fd, &savefds);
	        close_conn(conn_info_vector[fd].u.client.mate, &savefds);
	        for(j=0;j<(no_of_names-1); j++){
	    close_conn(conn_info_vector[fd].u.client.slv[j].slave, &savefds);
	        /*  continue; */
		}
	      }
	      free((void *)buff.foo);
	      if(slaves)
	        free((char *)slv.foo);
	    break;
	     }

	    case CLIENT:
	      packet_len = recv_request(i, packet, max_len);
	      data = packet_len + data_left;
	      /* get the active server for the client */
	      s = conn_info_vector[i].u.client.mate;
	      if(packet_len <= 0) {
	        if(packet_len == 0) {
	          /* free((char *)packet); */
	          free_garbage(s);
	          free_rids(s);
		  free_atoms(conn_info_vector[i].u.client.atoms);
	          close_conn(s, &savefds);
	          close_conn(i, &savefds);
	          for(j=0;j<(no_of_names-1);j++)
	            close_conn(conn_info_vector[i].u.client.slv[j].slave, &savefds);
		  reinitialize_display();
	        }
	        else {
	          printf("error: in receiving the request\n");
	          continue;
	        }
	      }
	      /* packet may contain more than one requests so process each 
	       * request separately */
	      if(data) {
	        for(cli=(char *)0,t=0; l=get_request(packet, &cli); t += l){
	          ++conn_info_vector[i].u.client.seq_no;
	          if(slaves)
	            process_request(cli, s, &conn_info_vector[i].u.client.atoms, conn_info_vector[i].u.client.seq_no);
	        }
	        slave = packet;
	        if(slaves) {
	          if(slave)
		     broadcast(conn_info_vector[i].u.client.slv, s, slave, t, conn_info_vector[i].u.client.atoms);
    		     remove_entry();
	        }

	        if(t) {
	          if((send_pkt(s, packet, t))!= t)
	          {
	            printf("error: in sending request to the server \n");
	            continue;
	          }
	        }
	        else
	          data_left = data;
	      }

	      break;

	    case MASTER:
	    {
	      int len, t_len, tmp;
	      buffer_t *buff;
	      char *mst;
	      int j;

	      /* packet_len = recv_request(i, packet, max_len);*/
	      buff = &conn_info_vector[i].u.master.buff;
	      len = recv_reply(i, (char *)buff->data, buff->n);
	      u = conn_info_vector[i].u.master.mate;
	      if( len == 0) {
	        close_conn(u, &savefds);
	        continue;
	      }

	      buff->size = len;
	      for(mst=(char *)0,t_len=0; l=get_reply(&conn_info_vector[i].u.master.buff, &mst); t_len += l){
	              store_atoms(mst, conn_info_vector[u].u.client.atoms, 0);
	      }
	      if((send_reply(u, buff, len)) != len) {
	        printf("error in sending the data to the client\n");
	        continue;
	      }

	      break;
	    }
	    case SLAVE:
	    {
	      int len, t_len, rem_bytes, tmp;
	      char *slv_buf;
	      buffer_t *foo;
	      int j;
	      int cli_fd;
	      xGenericReply *reply;

	      cli_fd = conn_info_vector[i].u.slave.client_mate;
	      foo = &conn_info_vector[i].u.slave.buff;
	      len = recv_reply(i, (char *)( conn_info_vector[i].u.slave.buff.data ), conn_info_vector[i].u.slave.buff.n);
	      if( len == 0) {
		printf(" ERROR : some error has occured in receiving reply from slave server\n");
		exit(1);
	      }
	      conn_info_vector[i].u.slave.buff.size = len;

	      for(slv_buf=(char *)0,t_len=0; l=get_reply(&conn_info_vector[i].u.slave.buff, &slv_buf); t_len += l){
	      reply = (xGenericReply *)conn_info_vector[i].u.slave.buff.data;
	      /****
		  if(reply->type == 0) {
		     printf(" Slave returned error code for %lu ...\n", reply->sequenceNumber);
		     continue;
	      }
	      ****/
	          if(slaves)
	              store_atoms(slv_buf, conn_info_vector[cli_fd].u.client.atoms, i);
	      }
	      if( (foo->n + foo->size) > t_len ) {
		rem_bytes = foo->n + foo->size - t_len;
		j = 0;
	        while(j < t_len) {
                  foo->data[j] = foo->data[j + t_len];
	          j = j+1;
	        }
	  	foo->n = rem_bytes;
              }
	      else 
		foo->n = 0;
	      break;
	    }
	  }
	}
      }
   }
}

/*
 *=========================================================================
 * This function broadcasts the request to all the slaves
 *=========================================================================
 */

void
broadcast(slv, s, cp, len, atoms)
Slv *slv;
int s;
char *cp;
int len;
ATOM *atoms;
{
    int i;
    char *buff;
    char *temp;
    char foo[data];
    struct buff_t send;

    memcpy((void *)foo, (void *)cp, data);
      for(i = 0; i < (no_of_names - 1); i++) {
	if(slv[i].mark == 1) {
            buff = (char *)0;
            temp = (char *)0;
	    while(get_request(cp, &buff) && get_request(foo, &temp))
	        ( void )map_request(slv[i].slave, temp, buff, atoms, slv[i].slave);
	        /*( void )map_request(s, temp, buff); */
	    if((send_bdcast(slv[i].slave, foo, len)) != len ) {
		printf("error in sending the data to slaves\n");
		continue;
	    }
	}
    }
}

/*
 *=========================================================================
 * This function reads the command line and then puts the host names
 * in the namelist array.
 *=========================================================================
 */

int
getNames(argc, namelist, argv)
int argc;
char **namelist;
char **argv;
{
	int i, j;

	j = 0;
	for(i = 2;  i < argc; i++) {
		namelist[j] = (char *)malloc(MAXSIZE);
		memcpy((void *)namelist[j], (void *)argv[i], MAXSIZE);
		j++;
	}
	return j++;
}


/*
 *==========================================================================
 * This function sets the socket fds for read.
 *==========================================================================
 */

 void
 set_fds(s, type, savefds)
 int s;
 short int type;
 fd_set *savefds;
 {
	conn_info_vector[s].type = type;
	FD_SET(s, savefds);
	if( s > max_fd)
	   max_fd = s;
}

/*
 *==========================================================================
 * This function closes the socket fds for read. And resets the maximum
 * socket fd.
 *==========================================================================
 */

void
close_conn(fd, savefds)
int fd;
fd_set *savefds;
{
	close(fd);
	conn_info_vector[fd].type = CLOSED;
	FD_CLR(fd, savefds);
	if (fd == max_fd) {
		while (conn_info_vector[--fd].type == CLOSED);
		max_fd = fd;
	}
}

void
close_slave_conn(fd, savefds)
int fd;
fd_set *savefds;
{
	close(fd);
	FD_CLR(fd, savefds);
	if (fd == max_fd) {
		while (conn_info_vector[--fd].type == CLOSED);
		max_fd = fd;
	}
}
