/* Data structures for buffering and manipulating utp messages.	*/

#ifndef UTPPDU_H
#define UTPPDU_H

#define CR_TYPE 0x4352          /* CR */
#define CA_TYPE 0x4341          /* CA */
#define C3_TYPE 0x4333          /* C3 */
#define DT_TYPE 0x2044          /*  D */
#define AK_TYPE 0x4120          /* A  */
#define AD_TYPE 0x4144          /* AD */
#define PB_TYPE 0x5042          /* PB */
#define XX_TYPE 0x5858          /* XX */

#define MAX_UTP_DATA 4000

/* Common part -- every PDU starts with this.	*/

struct comhdr 
{
    union {
	u_char  typec[2];
	u_short type;
    } u;
    u_short  destref;
    u_short  vers;
    __u32 csum;
};


/* "Rest" of a Conn Req msg header	*/

struct cr_rest {
    u_short origport;		/* originating utp port	*/
    u_short destport;		/* destination utp port */
    u_short origref;		/* sender's reference # */
    u_short initwin; 		/* initial receive window size */
};


/* "Rest" of a Conn Ack msg header	*/
struct ca_rest {
    u_short origport;		/* originating port #	*/
    u_short destport;		/* destination port #	*/
    u_short respref;		/* responding ref #	*/
    u_short initwin;		/* initial receive window size 	*/
};


/* Conn Conf, Probe, Disc Request, and Abort msgs have only fixed part	*/


/* Rest of a Data msg header	*/

struct d_rest {
   u_short seq;		/* sequence number of this PDU, starts at 0 */
   u_short len;		/* number of bytes of data (excluding header)    */
};

/* Rest of an Ack msg header */

struct a_rest {
   u_short ack;		/* ack sequence number */
   u_short subseq;	/* ack subsequence number */
   u_short win;		/* current receive window size */
};

/* complete PDU types	*/

typedef struct {
   struct comhdr ch;
   struct cr_rest r;
} cr_pdu_t;

typedef struct {
   struct comhdr ch;
   struct ca_rest r;
} ca_pdu_t;

typedef struct {
   struct comhdr ch;
   struct d_rest r;
   u_char x_data[MAX_UTP_DATA];	/* the data itself	*/
} d_pdu_t;

typedef struct {
   struct comhdr ch;
   struct a_rest r;
} a_pdu_t;

typedef struct {	/* this structure has the data pdu offset so	*/
   int dummy;		/* that sent data is aligned with that data in	*/
   struct comhdr ch;	/* an ad_pdu_t.					*/
   struct d_rest r;	/* this allows us to delay the decision on 	*/
   u_char x_data[MAX_UTP_DATA];	/* sending a piggybacked ack		*/
} sd_pdu_t;

typedef struct {
   struct comhdr ch;
   struct a_rest ar;
   struct d_rest dr;
   u_char x_data[MAX_UTP_DATA];	/* the data itself	*/
} ad_pdu_t;

typedef struct comhdr c3_pdu_t;
/* these aren't really needed -- they're all the same anyway */
/*
typedef struct comhdr xx_pdu_t;
typedef struct comhdr pb_pdu_t;
*/

typedef union {
    cr_pdu_t cr;
    ca_pdu_t ca;
    c3_pdu_t c3;	/* for all the common ones */
    d_pdu_t d;
    a_pdu_t a;
    sd_pdu_t sd;
    ad_pdu_t ad;
} pdu_t;
    
#define ch_destref	cr.ch.destref
#define ch_vers		cr.ch.vers
#define ch_type		cr.ch.u.type
#define ch_typec	cr.ch.u.typec
#define ch_csum		cr.ch.csum

#define cr_origport	cr.r.origport
#define cr_destport	cr.r.destport
#define cr_origref	cr.r.origref
#define cr_initwin	cr.r.initwin

#define ca_origport	ca.r.origport
#define ca_destport	ca.r.destport
#define ca_respref	ca.r.respref
#define ca_initwin	ca.r.initwin

#define d_seq		d.r.seq
#define d_len		d.r.len
#define d_data		d.x_data

#define a_ack		a.r.ack
#define a_subseq	a.r.subseq
#define a_win		a.r.win

#define sd_destref	sd.ch.destref
#define sd_vers		sd.ch.vers
#define sd_type		sd.ch.u.type
#define sd_typec	sd.ch.u.typec
#define sd_csum		sd.ch.csum
#define sd_seq		sd.r.seq
#define sd_len		sd.r.len
#define sd_data		sd.x_data

#define ad_seq		ad.dr.seq
#define ad_len		ad.dr.len
#define ad_data		ad.x_data

#define ad_ack		ad.ar.ack
#define ad_subseq	ad.ar.subseq
#define ad_win		ad.ar.win

/* General buffer type */

typedef struct pbuf {
        pdu_t pb_pdu;
        struct pbuf *pb_next;
        u_long pb_flags;
	int pb_dlen;		/* how many bytes of data (may be 0)	*/
	u_char *pb_data;	/* pointer to start of (received) data	*/
	__u32 pb_dcsum;	/* checksum over data portion (send)	*/
        u_short pb_seq;		/* sequence number of this PDU (send)	*/
	u_short pb_transct;	/* retransmission count	(send)	*/
} pbuf_t;

#endif
