/* implements the system call sys_utpOpen() */

#include <asm/uaccess.h>
#include <asm/system.h>
#include <linux/config.h>
#include <linux/string.h>
#include <net/utp.h>
#include <linux/mm.h>
#include <linux/file.h>
#include <linux/malloc.h>
#include <linux/net.h>
#include <linux/file.h>
#include <linux/utp/utppcb.h>
#include <linux/utp/utpaux.h>
#include <linux/utp/utptimeout.h>
#include <net/udp.h>

extern int inet_autobind(struct sock *sk);

/* Initialises pcbs, pbufs and connection buffers */ 
/* this function is called by utpOpen when establishing connection */
void utpInit()
{
   	int index;

	/* initialise all pcbs state to IDLE */
   	for (index=0; index<MAXPCB; index++) 
        	pcbs[index].up_state = IDLE;

   	/* initialize buffers */
	n_pbufs = MAXPBUF;
   	for (index=0; index<MAXPBUF; index++)
        	pbufs[index].pb_next = &pbufs[index+1];
   	pbufs[MAXPBUF-1].pb_next = NULL;
   	pbuffreelist = &pbufs[0];

   	/* initialize connection buffers */
   	for (index=0; index<MAXCBUF; index++)
        	conbufs[index].cb_next = &conbufs[index+1];
   	conbufs[MAXCBUF-1].cb_next = NULL;
   	conbuffreelist = &conbufs[0];

   	return;
}

/* This system call is called to establish 3-way connection between the server 
   & the client */
asmlinkage int sys_utpOpen(int utpSocket, Addr_t *desthost, utpPorts_t ports, int apflag)  
{ 
	pcb_t *p_pcb;  			/* pointer to new pcb */	
	int lrefno; 			/* local connection ref no (id) */
	int err;
	Addr_t dhost;			/* destination host */

	utpPort_t dport = ports.dport;
  	utpPort_t lport = ports.lport;

	first_time = 1;

	err = copy_from_user(&dhost,desthost, sizeof(Addr_t));
	if (err)
		return err;

	/* call utpInit only for the first time */
	if(first_time)
	{
		utpInit();
		first_time = 0;
	}

	/* get a new pcb */
	if ((lrefno = allocpcb())==0)
        	return ERR_TOOMANY;

    	p_pcb = &pcbs[lrefno];
	p_pcb->up_remport = dport;
	p_pcb->up_socketfd = utpSocket;

	if((p_pcb->up_socket = sockfd_lookup(p_pcb->up_socketfd,&err))== NULL)
        {
                //printk("Error in sockfd_lookup\n");
                return(-ENOTSOCK);
        }

        /* reffered to af_inet.c */
        p_pcb->up_sock = p_pcb->up_socket->sk;
	fput(p_pcb->up_socket->file);

	pcb_lock(lrefno);
	memcpy(&(p_pcb->up_rempsip.sa), &dhost, sizeof(struct sockaddr_in)); 
	if (apflag == UTP_ACTIVE) 
	{
		/* client */
        	if (IsWildcardAddress(&dhost) || (dport == 0)) 
		{
			pcb_unlock(lrefno);
            		return ERR_INVALID;
        	}  

		if (lport)
            		p_pcb->up_localport = lport;
        	else
            		p_pcb->up_localport = (utpPort_t) 1;

        	p_pcb->up_remref = 0;              /* initializing */
        	p_pcb->up_rcv_win = INITWIN;
		p_pcb->up_state = AOPNG;
		p_pcb->up_retries = 0;

		//printk("lrefno = %d\n",lrefno);
                startTimer(p_pcb->up_cto,CR_RTO,(void *)retransctl,lrefno);

		/* send the CR pdu */	
		if(sendctl(CR_TYPE,lrefno)<0)
		{
			pcb_unlock(lrefno);
			return ERR_INVALID;
		}
		{
		struct timeval tv;
		do_gettimeofday(&tv);
		p_pcb->startmicro = tv.tv_usec;
		}


		/* block until conn ack from the server */
		while ((p_pcb->up_state==AOPNG) &&
			(p_pcb->up_retries<MAXRETRY))
		{
	                if (signal_pending(current))
                        	break;
			pcbblock(lrefno);
		}
	
		/* when the conn ack is recd the state is changed to OPEN */
		if(p_pcb->up_state == OPEN)
		{
			p_pcb->up_retries = 0;
			printk("sending C3 ... \n");
			if(sendctl(C3_TYPE,lrefno)<0)
			{
				pcb_unlock(lrefno);
				return ERR_INVALID;
			}
		}
		/* if no of tries exceedes MAXRETRY or if state != OPEN, freeze the connection */
		else if (p_pcb->up_retries>=MAXRETRY)
		{
			p_pcb->up_state = FROZEN;
                        startTimer(p_pcb->up_cto,FREEZE_TO,(void *)freepcb,lrefno); 
			pcb_unlock(lrefno);
			return ERR_TIMEOUT;
		}
		else if (p_pcb->up_state == CLOSED)
		{
			p_pcb->up_state = FROZEN;
                        startTimer(p_pcb->up_cto,FREEZE_TO,(void *)freepcb,lrefno);
			pcb_unlock(lrefno);
			return ERR_REFUSED;
		}
		else
		{
			printk("Invalid State\n");
			freepcb(lrefno);
			pcb_unlock(lrefno);
			return ERR_INVALID;
		}

	}
	else if (apflag == UTP_PASSIVE)
	{
		/* server */
		/* local port cannot be zero */
		if (!lport)	
		{
            		freepcb(lrefno);
			pcb_unlock(lrefno);
			return ERR_INVALID;
		}
		/* change the server state to LSTNG */ 
		p_pcb->up_localport = lport;
		p_pcb->up_state = LSTNG;
	}
	else
	{
		printk("invalid apflag\n");
		freepcb(lrefno);
		pcb_unlock(lrefno);
		return ERR_INVALID;
	}	
	pcb_unlock(lrefno);
	return lrefno;
}


