#include <linux/socket.h>
#include <linux/string.h>
#include <net/sock.h>
#include <net/ip.h>
#include <net/icmp.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/inet.h>
#include <linux/mm.h>
#include <linux/net.h>
#include <linux/tcp.h>
#include <linux/netdevice.h>
#include <linux/proc_fs.h>
#include <linux/skbuff.h>
#include <net/utp.h>
#include <linux/utp/utp.h>
#include <linux/utp/utppdu.h>
#include <linux/utp/utpaux.h>
#include <linux/utp/utptimeout.h>
#include <linux/utp/utppcb.h>

#define wcmatch(x,y)	(((x)==0) || ((x)==(y)))

extern int sendctl( int, int);
extern int AddressToString(Addr_t *, char *);

/* This will copy from inubuf to pdu & also calculate checksum */
__u32 copyandcsum(char *inbuf , __u32 *p_pdu, int pdulen)  
{ 
	__u32 csum=0;
    	int index;  
    	union 
    	{
       		u_char c[4];
       		__u32 w;
    	} foo;

    	foo.w = 0;
    	for (index=0; index<pdulen; index++) 
    	{
        	foo.c[index%4] = *inbuf++;
        	if (index%4 == 3) 
        	{
            		csum ^= foo.w;
            		*p_pdu++ = foo.w;
        	}
    	}
    	if (pdulen%4) 
    	{     
		/* a byte or three left over    */
		//printk("Length not multiple of four\n");
        	for (index=pdulen%4; index<4; index++)
            		foo.c[index] = 0;
        	csum ^= foo.w;
        	*p_pdu++ = foo.w;
    	}
   
	if(csum != CSUMRESULT)
		printk("ERROR in csum\n");
    	return csum;
}

/* Find a match for an incoming CR pdu.					*/
/* A pcb matches if:							*/
/*    its state is POPNG AND its remote ref == pdu's orig ref		*/
/*    its state is LSTNG AND its remport matches pdu's orig port	*/
/*			 AND its rempsip matches the src psip		*/
/*			 AND its localport == pdu's dest port		*/
int findmatchingpcb(Addr_t *srcpsip,utpPort_t srcprt, utpPort_t
						dstprt, u_char orgref)
{
int index;
pcb_t *p_pcb;

    	for (index=1,p_pcb=&pcbs[1]; index<MAXPCB; index++,p_pcb++) 
	{
		if ((p_pcb->up_state==POPNG) &&
	    		(p_pcb->up_remref==orgref))	/* a duplicate CR */
	    	break;

		if ((p_pcb->up_state==LSTNG) &&
	    		wcmatch(p_pcb->up_remport,srcprt) &&
	    		EqualAddresses(&p_pcb->up_rempsip,srcpsip) &&
	    		(p_pcb->up_localport==dstprt))
	    	break;
    	}

    	if (index==MAXPCB) 
		return 0;
    	return index;
}

/* add a newborn connection to the ready list of its parent	*/
/* state of new connection is OPEN at this point		*/
void confirmconn(int ref)
{
pcb_t *p_pcb;
conbuf_t *cb, *temp;
int parent;

    	parent = pcbs[ref].up_parent;

    	cb = allocconbuf();
    	cb->cb_conn = ref;
    	p_pcb = &pcbs[parent];
    	temp = p_pcb->up_rdylast;
    	if (temp==NULL) 
	{
		p_pcb->up_rdyfirst = p_pcb->up_rdylast = cb;
    	} 
	else 
	{      /* temp != NULL */
		temp->cb_next = cb;
		p_pcb->up_rdylast = cb;
    	}

    	pcbunblock(ref);		
		/* an ACCEPT may be waiting */

}

/* Process a received acknowledgement */
void doack(struct a_rest *ack_rest, int ref)
{
pcb_t *p_pcb;
pbuf_t *buf;
u_short snd_lim;
int advertised_window, effective_window;
unsigned int rto=0;

        p_pcb = &pcbs[ref];

	if (ack_rest->ack >= p_pcb->up_snd_nxt)
	{
		struct timeval tv;
		do_gettimeofday(&tv);
		if(p_pcb->startmicro != -1)
			/* normal data transfer */
		{
		p_pcb->endmicro = tv.tv_usec;
		p_pcb->rtt = p_pcb->endmicro - p_pcb->startmicro;
		if(p_pcb->max_rtt < p_pcb->rtt)
			p_pcb->max_rtt = p_pcb->rtt;
		}
	}

        /* increase the congestion window */    
        if(p_pcb->congest_window < p_pcb->congest_threshold) 
	{
		/* increase by 1 for every acked PDU */
		if((ack_rest->ack - p_pcb->up_snd_una) > 0)
                    p_pcb->congest_window += (ack_rest->ack-p_pcb->up_snd_una); 
	}
	else 
	{
		/* increase by one for every round trip */
		if((ack_rest->ack > p_pcb->slowstart_ref) &&
			(p_pcb->slowstart_ref != -1))
		{
                    p_pcb->congest_window += 1;     
		    p_pcb->slowstart_ref = -1;
		}
	}

	if(p_pcb->congest_window > INITWIN)
		p_pcb->congest_window = INITWIN;

        if (UTPSEQ_LT(p_pcb->up_snd_una,ack_rest->ack))
        { /* acks some messages */
                buf = p_pcb->up_sentfirst;
                while (buf!=NULL && UTPSEQ_LT(buf->pb_seq,ack_rest->ack))
                {
                        p_pcb->up_sentfirst = buf->pb_next;
                        freepbuf(buf);
			if(n_pbufs > 0)
				pcbunblock(ref);
                        buf = p_pcb->up_sentfirst;
                }
                if (buf==NULL)
                {               /* everything has been acked */
                        p_pcb->up_sentlast = NULL;
                        if (p_pcb->up_flags & RTTO_PENDING)
                        {
                                cancelTimer(p_pcb->up_sto);
                                p_pcb->up_flags &= ~RTTO_PENDING;
                        }
                }
                /* get the new window info */
                p_pcb->up_snd_una = ack_rest->ack;
                p_pcb->up_snd_win = ack_rest->win;
                p_pcb->up_snd_ass = ack_rest->subseq;
		if((p_pcb->up_snd_nxt - p_pcb->up_snd_una) < p_pcb->up_snd_win)
			pcbunblock(ref);
        }

        if (p_pcb->up_snd_una==ack_rest->ack && UTPSEQ_LT(p_pcb->up_snd_ass,ack_rest->subseq))
        {
                /* no new ack, but new window info */
                p_pcb->up_snd_win = ack_rest->win;
                p_pcb->up_snd_ass = ack_rest->subseq;
        }
        /* Now we have to check whether something has become sendable */
        advertised_window = p_pcb->up_snd_win;
        effective_window = MIN(advertised_window,p_pcb->congest_window);

        snd_lim = p_pcb->up_snd_una + effective_window;
        while (UTPSEQ_LT(p_pcb->up_snd_nxt,snd_lim) && p_pcb->up_unsentfirst)
        {
                /* window open && something to send */
                /* get the first unsent PDU     */
                buf = p_pcb->up_unsentfirst;
                p_pcb->up_unsentfirst = buf->pb_next;
                buf->pb_next = NULL;
                p_pcb->up_snd_nxt++;

                if (p_pcb->up_sentlast==NULL)  /* empty list */
                {
                        p_pcb->up_sentlast = p_pcb->up_sentfirst = buf;
                }
                else
                {
			/* Insert in the sorted list */
			if(p_pcb->up_sentlast->pb_seq >= buf->pb_seq)
				printk("SENT LIST NOT SORTED");
                        p_pcb->up_sentlast->pb_next = buf;
                        p_pcb->up_sentlast = buf;
                }
		if(p_pcb->slowstart_ref == -1)
			p_pcb->slowstart_ref = buf->pb_seq;
                senddata(ref,buf);
		if(p_pcb->up_flags & RTTO_PENDING)
			cancelTimer(p_pcb->up_sto);

                rto = (2 * p_pcb->rtt)/1000;

                startTimer(p_pcb->up_sto,rto, (void *)retransdata,ref);
		p_pcb->up_flags |= RTTO_PENDING;

        }       /* while room in window and unsent list not empty */

        return;
}


/* Process an incoming PDU.						*/
/* Reply messages are sent, timers started, etc. from the top half,	*/
/* except in situations where it is not waiting for something,		*/
/* e.g. when a duplicate or bogus message is received.			*/
/* Another exception is canceling timers, which gets done here to	*/
/* minimize the chance of one expiring needlessly.			*/

//void utpInput(char *inbuf, int len, Addr_t *from)
int utpInput(char *inbuf, int len, Addr_t *from)
{
pcb_t *p_pcb, *p_newpcb, *p_oldpcb;
pdu_t temppdu, *ppdu;
pbuf_t *pbuf;
int ref, havebuf=0;
int newref;

/* we check here for a data-carrying PDU, so we don't have to allocate	*/
/* a buffer from the pool in case of a control-only PDU.		*/

    	if (*(inbuf) == 'D')
    	{
		if (( pbuf= allocpbuf())==NULL)	
		{
			printk("allocpbuf returned NULL !!!!!!!!!!\n");
	    		return ERR_NOBUFS;
		}
		ppdu = &pbuf->pb_pdu;	
		havebuf = 1;
    	} 
	else 
		ppdu = &temppdu; 

	/* Check for a well-formed PDU.	*/
    	if (copyandcsum(inbuf,(__u32 *) ppdu,len) != CSUMRESULT)  
    	{
        	printk("received %d-byte PDU with a bad checksum:\n",len);
		if (havebuf)
	    		freepbuf(pbuf);
		return ERR_INVALID;
    	}

	/* Find the destination endpoint */
    	if (ppdu->ch_destref == 0) 
	{	/* better be a CR msg */

		if (ppdu->ch_type != CR_TYPE) 
		{
	    		if (havebuf)
				freepbuf(pbuf);
	    		return ERR_INVALID;
		}
        	/* TYPE == CR_TYPE */

		/* the PDU is a request for new connection; look for a match. */
		ref = findmatchingpcb(from,ppdu->cr_origport,ppdu->cr_destport,
			ppdu->cr_origref);

		newref = allocpcb();	/* this is the new connection! */
		if(newref == 0)
			return ERR_NOTCONN;

		p_newpcb = &pcbs[newref];

		/* copy the addr info */
        	(p_newpcb->up_rempsip).sa.sin_addr.s_addr = from->sa.sin_addr.s_addr;
        	(p_newpcb->up_rempsip).sa.sin_family = from->sa.sin_family;
        	(p_newpcb->up_rempsip).sa.sin_port = from->sa.sin_port;

		/* copy the other info from incoming CR pdu */
		p_newpcb->up_remport = ppdu->cr_origport;
		p_newpcb->up_localport = ppdu->cr_destport;
		p_newpcb->up_remref = ppdu->cr_origref;
		p_newpcb->up_snd_win = ppdu->cr_initwin;
		p_newpcb->up_rcv_win = INITWIN;
		p_newpcb->up_state = POPNG;

		if (ref == 0 || newref==0) 
		{
	    		if(sendctl(XX_TYPE,newref)<0)
			{
				freepcb(newref);
				return ERR_INVALID;
			}
	    		if (newref) 
			{
				freepcb(newref);
	    			return ERR_INVALID;
			}
		}
		/* ref != 0 && newref != 0 */
		/* keep a pointer back to the parent */
		p_newpcb->up_parent = ref;

		p_oldpcb = &pcbs[ref];
		p_newpcb->up_socketfd = p_oldpcb->up_socketfd;
		pcbs[newref].up_socket = pcbs[ref].up_socket;
		pcbs[newref].up_sock = pcbs[ref].up_sock;

                startTimer(p_newpcb->up_cto,CA_RTO,(void *)retransctl,newref);

        	if(sendctl(CA_TYPE,newref)<0)
		{
			printk("error in sending CA \n");
			return ERR_INVALID;
		}

	        {
			struct timeval tv;
			do_gettimeofday(&tv);
			p_pcb->startmicro = tv.tv_usec;
		}

		/* nothing more to do here; connection will get added to pcb's	
		list of pending connections when the C3 (or data) comes in*/
		return 0;

    	}

    	/* Plausible destination reference: ppdu->ch_destref != 0	*/
    
    	ref = ppdu->ch_destref;
    	p_pcb = &pcbs[ref];

	pcb_lock(ref);
	/* process other pdus */
    	switch (ppdu->ch_type) 
	{

    	case CA_TYPE:

	{
		struct timeval tv;
		do_gettimeofday(&tv);
		p_pcb->endmicro = tv.tv_usec;
		p_pcb->rtt = p_pcb->endmicro - p_pcb->startmicro;
		p_pcb->max_rtt = p_pcb->rtt;
	}

	if (p_pcb->up_state==AOPNG) 
	{
		/* sanity check	*/
	    	if ((p_pcb->up_remport != ppdu->ca_destport) ||
			(p_pcb->up_localport != ppdu->ca_origport)) 
		{
			/* here is a PDU with a plausible dest ref	*/
			/* but a wrong port number.  			*/
			/* we ignore it -- for now.			*/
	
			pcb_unlock(ref);
			return ERR_INVALID;
	    	}
	
		/* copy  the info from CA pdu */	
	    	p_pcb->up_remref = ppdu->ca_respref;
	    	p_pcb->up_snd_win = ppdu->ca_initwin;
	    	p_pcb->up_state = OPEN;
		cancelTimer(p_pcb->up_cto);
	    	pcbunblock(ref);		
			
			/* Active conn: Open() is a-waitin'	*/
	} 
	else if (p_pcb->up_state==OPEN)
	{	/* this CA is a duplicate */
	    	if(sendctl(C3_TYPE,ref)<0)
		{
			pcb_unlock(ref);
			return ERR_INVALID;
		}
	}

	else
		/* In case it's not us, we'll send XX to prevent	*/
		/* half-open connections.				*/
	    	if(sendctl(XX_TYPE,ref)<0)
		{
			return ERR_INVALID;
		}
	break;	/* End CA case */

    	case CR_TYPE:	/* malformed message: CR needs dest ref.= 0	*/
	break;

    	case C3_TYPE:
	if (p_pcb->up_state==POPNG) 
	{
		/* This (passive) connection is now OPEN.		*/
		/* we transfer it to the ready list of the pcb 		*/
	    	cancelTimer(p_pcb->up_cto); 
	    	p_pcb->up_state = OPEN;
	    	confirmconn(ref);	/* confirmconn does the wakeup! */

	}

	{
		struct timeval tv;
		do_gettimeofday(&tv);
		p_pcb->endmicro = tv.tv_usec;
		p_pcb->rtt = p_pcb->endmicro - p_pcb->startmicro;
		p_pcb->max_rtt = p_pcb->rtt;
	}

	/* otherwise the PDU is a duplicate; ignore it.			*/
	break;
	
        case AK_TYPE:
        if (p_pcb->up_state == OPEN)
        {
		/* In case we have started the probe timer */
		if(p_pcb->up_flags & PB_PENDING)
		{
			cancelTimer(p_pcb->up_cto);
			p_pcb->up_flags &= ~PB_PENDING;
		}
                doack(&ppdu->a.r,ref);
        }
        else                            /* otherwise, don't bother.     */
        {
                printk( "Got an ACK message in an invalid state\n");
                if (p_pcb->up_state == CLOSED || p_pcb->up_state == FROZEN)
                        sendctl(XX_TYPE,ref);
        }
        break;
        
	case AD_TYPE:
        if (p_pcb->up_state == OPEN)    /* shouldn't happcben in POPNG */
                doack(&ppdu->ad.ar,ref);
        else
                printk("Got an AD message in an invalid state");

        pbuf->pb_data = ppdu->ad_data;  /* so we don't have to hunt later */
        pbuf->pb_seq = ppdu->ad_seq;
        pbuf->pb_dlen = ppdu->ad_len;

        /* and fall through ... */

        case DT_TYPE:
        if (ppdu->ch_typec[1] == ' ')
        { /* not AD_TYPE */
                pbuf->pb_data = ppdu->d_data;   /* extract the common info */
                pbuf->pb_seq = ppdu->d_seq;
                pbuf->pb_dlen = ppdu->d_len;
        }
        if (p_pcb->up_state == POPNG)
        {  /* this confirms the connection */
                p_pcb->up_state = OPEN;
                confirmconn(ref);
        }
        if (p_pcb->up_state != OPEN)
        {       /* can't receive data in this state */
                freepbuf(pbuf);

                if (p_pcb->up_state == CLOSED ||
                        p_pcb->up_state == FROZEN)
                        sendctl(XX_TYPE,ref);   /* somebody missed the close */
                break;
        }

        /* the common case: next expected sequence number. */
        /* put on the deliverable list and see if there's anything else */
        /* to be transferred up. */
        if (pbuf->pb_seq == p_pcb->up_rcv_nxt)
        {
                pbuf_t *lp = p_pcb->up_dellast;

                if (lp == NULL) /* delfirst==dellast==NULL */
                {
                        p_pcb->up_delfirst = p_pcb->up_dellast = pbuf;
                }
                else  /* lp points to the last buffer in the list */
                        lp->pb_next = p_pcb->up_dellast = pbuf;
                p_pcb->up_rcv_nxt += 1;
                p_pcb->up_rcv_acnt = 0; /* haven't sent this ack yet */
                p_pcb->up_rcv_win -= 1;
                pbuf->pb_next = NULL;   /* singly-linked list */

                /* now transfer stuff held for resequencing */
                while (((lp = p_pcb->up_rcvlist) != NULL) &&
                   (lp->pb_seq==p_pcb->up_rcv_nxt))
                {
                        pbuf->pb_next = p_pcb->up_dellast = lp;
                        pbuf = lp;
                        pbuf->pb_next = NULL;
                        p_pcb->up_rcvlist = lp->pb_next;
                        p_pcb->up_rcv_nxt += 1;
                        p_pcb->up_rcv_win -= 1;
                }

                pbuf->pb_next = NULL;

                pcbunblock(ref);

        }
        else if (UTPSEQ_LT(p_pcb->up_rcv_nxt,pbuf->pb_seq) &&
                 UTPSEQ_LT(pbuf->pb_seq,p_pcb->up_rcv_nxt+p_pcb->up_rcv_win))
        {

                /* the PDU is out of order, but in the window */
                pbuf_t *lp, *llp;

                printk("PDU with seqno %d is out of order, but in window \n", pbuf->pb_seq);
                lp = p_pcb->up_rcvlist;
                llp = NULL;
                if (lp == NULL)
                {
                        p_pcb->up_rcvlist = pbuf;
                        pbuf->pb_next = NULL;
                }
                else
                {       /* lp != NULL: something is on the rcvlist */

                        /* find a PDU AFTER this one, or the end of the list */
                        while (UTPSEQ_LT(lp->pb_seq,pbuf->pb_seq) && lp->pb_next
)
                        {
                                llp = lp;
                                lp = lp->pb_next;
                        }

                        /* lp->pb_seq >= pbuf->pb_seq || lp->pb_next == NULL */

                        if (UTPSEQ_LT(lp->pb_seq,pbuf->pb_seq))
                        { /* lp->pb_next==NULL */
                        /* new  entry is last in the list */
                                lp->pb_next = pbuf;
                                pbuf->pb_next = NULL;
                        }
                        else if (lp->pb_seq == pbuf->pb_seq)
                        {
                                /* a duplicate */
                                printk("Its a duplicate \n");
                                freepbuf(pbuf);
                                break;
                        }
                        else
                        { /* lp->pb_seq > pbuf->pb_seq */
                                pbuf->pb_next = lp;
                                if (llp != NULL)
                                        /* llp != NULL => llp->_next==lp */
                                        llp->pb_next = pbuf;
                                else
                                        p_pcb->up_rcvlist = pbuf;
                        }

                }       /* add to nonempty buffer list */

        } /* end of out-of-order case */
        else
        {
                /* the PDU is an old duplicate, discard it and ack it */
                printk("discarding the pdu !!!!!!!!!!!!!!!!!!!!!!!\n");
                freepbuf(pbuf);
        }
        if(sendctl(AK_TYPE,ref)<0)
	{
		pcb_unlock(ref);
                return ERR_INVALID;	
	}
        break;
        case PB_TYPE:
                switch(p_pcb->up_state)
                {
                case OPEN:
                        if(sendctl(AK_TYPE,ref)<0)
			{
                                return ERR_INVALID;
			}
                        break;
                case CLOSED:
                case FROZEN:
                        if(sendctl(XX_TYPE,ref)<0)
			{
                                return ERR_INVALID;
			}
                default:
                        break;
                }
        	break;

        case XX_TYPE:
        if (p_pcb->up_state == IDLE)
	{
		pcb_unlock(ref);
                return 0;
	}
        if (p_pcb->up_state == FROZEN || p_pcb->up_state == OPEN)
        {
                if(sendctl(XX_TYPE,ref)<0)
		{
			pcb_unlock(ref);
                        return ERR_INVALID;  /* we have to ack their XX */
		}
        }
        else if (p_pcb->up_state == PCLSNG)
        { /* we closed first */
                cancelTimer(p_pcb->up_cto);
                p_pcb->up_flags |= CLEAN_CLOSE;  /* both sides know it */
        }

        p_pcb->up_state = CLOSED;       /* TOP HALF must set it to FROZEN */
        pcbunblock(ref); 	/* in case it is blocked */

        break;

    	default:		
		break;

    	}	/* switch on PDU type	*/
	pcb_unlock(ref);
    	return 0;

}	/* Input */

/* this function is called by ip_rcv when some message arrives */
int utp_rcv(struct sk_buff *skb, unsigned short len)
{
        struct utphdr *uth;
        char *buf;
        int buf_len;
	int true_size;
	Addr_t from;
	struct sock *sk;
        u32 saddr = skb->nh.iph->saddr;
        u32 daddr = skb->nh.iph->daddr; 
	
	//printk("In utp_rcv\n");	

        /*      Get the header. */
        uth = (struct utphdr *) skb->h.uth;
        __skb_pull(skb, skb->h.raw - skb->data);

        ip_statistics.IpInDelivers++;

        /*      Validate the UTP length. */

	len = skb->len;
        if (len < sizeof(struct utphdr))
	{
		kfree_skb(skb);
		return ERR_INVALID;
	}

        sk = utp_v4_lookup(saddr, uth->source, daddr, uth->dest, skb->dev->ifindex);
        if (sk == NULL) 
	{
                utp_statistics.UtpNoPorts++;
                icmp_send(skb, ICMP_DEST_UNREACH, ICMP_PORT_UNREACH, 0);

                kfree_skb(skb);
                return(0);
	}

	/* get the buf & buf_len from skb */
	true_size = skb->len - sizeof(struct utphdr);
	buf = (char *)(skb->data+sizeof(struct utphdr));
	buf_len = true_size;

	/* get the addr info from skb */
	from.sa.sin_addr.s_addr = skb->nh.iph->saddr;	
	from.sa.sin_family = AF_INET;
	from.sa.sin_port = skb->h.uth->source;

        {
        char temp_string[20];
        AddressToString(&from, temp_string);
        //printk(" Packet recd from %s \n", temp_string);
	//printk("Packet recd is %s\n",buf);

        }

	/* call utpInput for further processing */
        if(utpInput(buf,buf_len,&from)<0)
		return ERR_INVALID;
	kfree_skb(skb);
        return 0;
}

