/* implements allocpbuf, freepbuf, allocpcb, freepcb, pcbblock, pcbunblock,        pcb_lock, pcb_unlock */

#include <asm/uaccess.h>
#include <asm/system.h>
#include <linux/socket.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/net.h>
#include <linux/timer.h>
#include <linux/proc_fs.h>
#include <net/utp.h>
#include <linux/utp/utppdu.h>
#include <linux/utp/utppcb.h>
#include <linux/utp/utpaux.h>
#include <linux/utp/utptimeout.h>
#include <net/udp.h>
#include <linux/sched.h>
#include <net/sock.h>
#include <asm/semaphore.h>

/* This function returns pointer to pbuf_t 
   reduces no. of pbufs available */              
pbuf_t *allocpbuf(void)
{
pbuf_t *p_buf;
	
	start_bh_atomic();
    	if ((p_buf=pbuffreelist)!= NULL) 
	{
        	pbuffreelist = p_buf->pb_next;
        	p_buf->pb_flags = 0;
        	n_pbufs--;
    	}
	end_bh_atomic();
    	return p_buf;
}

/* This function frees the pbuf passed as argument 
   increases no. of pbufs available */    
void freepbuf(pbuf_t *pb)
{   

	start_bh_atomic();
    	if (pb != NULL) 
    	{
        	pb->pb_next = pbuffreelist;
        	pbuffreelist = pb;
        	n_pbufs++;
    	}
	end_bh_atomic();
}

/* This function allocates pcb for new connection. 
   It initialises congest_window & congest_threshold. */
int allocpcb(void)
{
int index;   
  
    	for (index=1; index<MAXPCB; index++)
        if (pcbs[index].up_state == IDLE) 
	{
            	memset(&pcbs[index],0,sizeof(pcb_t));  /* wipe out everything*/
            	pcbs[index].up_state = MARKED;
		// initialise the CW
		pcbs[index].congest_window = INITWIN;	
		pcbs[index].congest_threshold = INITWIN;
		pcbs[index].slowstart_ref = -1;

		pcbs[index].up_sto=kmalloc(sizeof(struct timer_list),GFP_ATOMIC);
		pcbs[index].up_cto=kmalloc(sizeof(struct timer_list),GFP_ATOMIC);
            	break;
        }
  
    	if (index==MAXPCB) return 0;    /* nothing available ! */
    		return index;
}

/* This function frees the pcb */
void freepcb(int ref)
{       
pcb_t *p_pcb;
pbuf_t *pbuf, *next_pbuf;

   
	if((ref<1)||(ref>MAXPCB))
		return;   
    	p_pcb = &pcbs[ref];
	printk("In freepcb\n");
            
        if (p_pcb->up_flags & RTTO_PENDING)
        {
        	//printk("calling cancelT in freepcb\n");
                cancelTimer(p_pcb->up_sto);
                p_pcb->up_flags &= ~RTTO_PENDING;
        }

	cancelTimer(p_pcb->up_cto);

	/* free any data blocks left hanging around     */
    	if (p_pcb->up_sentfirst != NULL) 
	{
       		pbuf = p_pcb->up_sentfirst;
        	do 
		{
            		next_pbuf = pbuf->pb_next;
            		freepbuf(pbuf);
            		pbuf = next_pbuf;
        	} while (pbuf != NULL);
    	}
    	if (p_pcb->up_unsentfirst != NULL) 
	{
        	pbuf = p_pcb->up_unsentfirst;
        	do 
		{
            		next_pbuf= pbuf->pb_next;
            		freepbuf(pbuf);
            		pbuf = next_pbuf;
        	} while (pbuf != NULL);
    	}   

    	if (p_pcb->up_delfirst != NULL) 
	{
        	pbuf = p_pcb->up_delfirst;
        	do 
		{
            		next_pbuf = pbuf->pb_next;
            		freepbuf(pbuf);
            		pbuf = next_pbuf;
        	} while (pbuf != NULL);
	}

    	if (p_pcb->up_rcvlist != NULL) 
	{
        	pbuf = p_pcb->up_rcvlist;
        	do 
		{
            		next_pbuf = pbuf->pb_next;  
            		freepbuf(pbuf);
            		pbuf = next_pbuf;
        	} while (pbuf != NULL);
    	}
        
    	p_pcb->up_state = IDLE;
	printk("freepcb: at the end of pcb ref = %d \n", ref);
}

/* This function allocates connection buffer */
conbuf_t *allocconbuf(void)
{
    	conbuf_t *p_cbuf;
    
    	p_cbuf = conbuffreelist;
    	conbuffreelist = p_cbuf->cb_next;
    	p_cbuf->cb_next = NULL;
    	return p_cbuf;
}
    
/* This function frees connection buffer */
void freeconbuf(conbuf_t *p_cbuf)
{

    	if (p_cbuf != NULL) 
	{
        	p_cbuf->cb_conn = -1;   
        	p_cbuf->cb_next = conbuffreelist;
        	conbuffreelist = p_cbuf;
    	}
	return;
}   

void pcbblock(int ref)
{
pcb_t *p_pcb;
struct sock *p_sock;

        p_pcb = &pcbs[ref];
	p_sock = p_pcb->up_sock;

	if(p_sock == NULL)
		printk("psock is NULL in pcbblock\n");
	//lock_sock(p_sock);
        interruptible_sleep_on(p_sock->sleep);
	//release_sock(p_sock);
        return ;
}

void pcbunblock(int ref)
{
pcb_t *p_pcb;
struct sock *p_sock;

        p_pcb = &pcbs[ref];
	p_sock = p_pcb->up_sock;

        if(!(p_sock->sleep))
                return;
	//lock_sock(p_sock);
        wake_up_interruptible(p_sock->sleep);
	//release_sock(p_sock);
        return;
}

void pcb_lock(int ref)
{
pcb_t *p_pcb= &pcbs[ref];

	if(p_pcb->up_sock == NULL)
		printk("p_pcb->up_sock is NULL in pcb_lock\n");
	lock_sock(p_pcb->up_sock);	
return;
}

void pcb_unlock(int ref)
{
pcb_t *p_pcb= &pcbs[ref];

	release_sock(p_pcb->up_sock);
return;
}





