#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>  /* for gethostbyname() and struct hostent */
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <netinet/in.h> /* for sockaddr_in */
#include <sys/time.h>   /* for struct timeval */
#include <string.h>
#include <syscall.h>
#include <ctype.h>
#include <unistd.h>
#include "test_client.h"

int AddressToString(Addr_t *address,char *string)
{
  if(string==NULL)
  {
    printf("AddressToString given NULL string\n");
    return -1;
  }
  if(address == NULL)
  {
       printf("AddressToString given NULL address");
       return -1;
  }

  sprintf(string,"%u.%u.%u.%u!%d",
        (unsigned int)ntohl(address->sa.sin_addr.s_addr)>>24 & 0xff,
        (unsigned int)ntohl(address->sa.sin_addr.s_addr)>>16 & 0xff,
        (unsigned int)ntohl(address->sa.sin_addr.s_addr)>>8 & 0xff,
        (unsigned int)ntohl(address->sa.sin_addr.s_addr) & 0xff,
        (int)(address->sa.sin_port));

  return 0;
}

int psipStringToAddress(char *string,Addr_t *address)
{
  int a,b,c,d,p;

  if(string==NULL)
  {
  	printf("psipStringToAddress given NULL string");
        return -1;
  }
  if(address==NULL)
  {
  	printf("psipStringToAddress given NULL address");
        return -1;
  }

  address->sa.sin_family = AF_INET;

  /* throw away leading blanks, since they make gethostbyname() choke.  */
  while (string[0]==' ' || string[0]=='\t') string++;

  /* is the first character a digit?
     If so, we assume "w.x.y.z!port"
     If not, we assume "hostname!port" */
  if (isdigit(string[0]))
  {
    if(sscanf(string,"%d.%d.%d.%d!%d",&a,&b,&c,&d,&p) != 5)
    {
       printf("Unable to parse address\n");
       return -1;
    }
    address->sa.sin_addr.s_addr = a<<24 | b<<16 | c<<8 | d;
    address->sa.sin_port = p;
  }
  else /* we dont have a digit first */
  {
    char *port;

    /* find the '!' in string: format must be hostname!port*/
      if( (port = index(string,'!')) == NULL)
      {
          printf("Unable to parse address");
	  return -1;
      }

    /* split string in two... hostname\0port\0 and increment port past \0 */
      *port++ = '\0';

    /* look-up hostentry for the hostname */
    {
      struct hostent *destHostEntry;

      /* find the hostEntry for string */
      if( (destHostEntry = gethostbyname(string)) == NULL)
      { 
            printf("Unable to get address for our string");
            return -1;
      }
      /* copy the address from the hostEntry into ourPSIPAddr.sa */
        bcopy(destHostEntry->h_addr_list[0],
          &address->sa.sin_addr.s_addr,
      destHostEntry->h_length);

	//printf("Add is ---> %u \n", address->sa.sin_addr.s_addr);

      address->sa.sin_port = atoi(port);
    } /* look-up the hostentry for hostname */

  } /* else (we have hostname!port) */

  return 0;
}

int OSinit(myport)
{
	unsigned long args[3];
  if (ourSocket != -1)
  {
    /* We're already initialized, just return 0 */
    return 0;
  }
  //if((ourSocket = syscall(102,SYS_SOCKET,AF_INET,SOCK_UTP_DGRAM,0)) < 0)
  //if((ourSocket = socket(AF_INET,SOCK_DGRAM,0)) < 0)
  args[0]= (u_long)AF_INET;
  args[1]= (u_long)SOCK_UTP_DGRAM;
  args[2]= (u_long)0;
  if((ourSocket = syscall(102,SYS_SOCKET,args)) < 0)
  {
    printf("ourSocket is %d\n",ourSocket);
    printf("Failed to allocate our socket!");
    return 0;
  }
  ourPSIPAddr.sa.sin_addr.s_addr = INADDR_ANY;  
  ourPSIPAddr.sa.sin_port = myport;
  ourPSIPAddr.sa.sin_family = AF_INET;
  if (bind(ourSocket, (struct sockaddr *) &ourPSIPAddr.sa,
			sizeof(ourPSIPAddr.sa)) < 0)
  {
     printf("Unable to find our socket!");
     return 0;
  }

  {
    char ourHostName[200];
    struct hostent *ourHostEntry;
      
    /* first, find our local hostname */  
    if(gethostname(ourHostName, sizeof(ourHostName)) != 0)
    {
	printf("Unable to get our hostname");
	return 0;
    }
                          
    /* now, find the hostEntry for our hostname */
    if((ourHostEntry = gethostbyname(ourHostName)) == NULL)
    {
    	printf("Unable to get address for our hostname");
    	return 0; 
    }

    /* copy the address from the hostEntry into ourPSIPAddr.sa */
    bcopy(ourHostEntry->h_addr_list[0],&ourPSIPAddr.sa.sin_addr.s_addr,
      					ourHostEntry->h_length);
  }
  return 1;
}
	
int main()
{
  int myport = 0;
  char destInput[BUF_SIZE];
  Addr_t destAddr;
  char aString[BUF_SIZE];
  int rv=0;
  //utpPort_t  activePort =101;
  utpPorts_t ports;
  char buf[40];
  char buf1[40];
  int len;
  int result,i;

  if (OSinit(myport) <= 0) 
  {  
        printf("Error in initialization\n");
        exit(1);
  }
	
  sprintf(destInput,"%s!%d",SERVERHOST,SERVER_PORT);

  if(psipStringToAddress(destInput,&destAddr) != 0)
  {
        printf("Unable to turn destination Input into address\n");
        return 0;
  }
   
  if(AddressToString(&destAddr,aString) != 0)
  {
	printf("Unable to convert destAddr back to a string!\n");
        return 0;
  }
  
  //printf("Connecting actively to %s\n", aString);
  
  ports.lport = 0;
  ports.dport = SERVER_PORT;
  
  rv = syscall(191,ourSocket,&destAddr,ports,UTP_ACTIVE);
  if (rv < 0) 
  {
	printf("rv = %d\n",rv);
        printf("Open failed, returned %d\n",rv);
	return 0;
  }
  else
  {
	printf("rv = %d Successful\n",rv);
  }
  sleep(2);
  strcpy(buf,"TESTDATA");
  strcpy(buf1,"God gimee a break !!!!!!!!!!!!!!!!");
  len = strlen(buf);
  //printf("the data being sent is %s & len is %d\n", buf,len);
  for(i=0;i<5;i++)
  {
  result = syscall(192,rv,UTPCOM_SEND,(void *)buf,&len);
  if(result!=0)
  {
	printf("result = %d\n", result);
	printf("Data send unsucccessful\n");
  }
  }
  /*len = strlen(buf1);
  result = syscall(192,rv,UTPCOM_SEND,(void *)buf1,&len);
  if(result==0)
	printf("Data send succcessfully\n");
  else
  {
	printf("result = %d\n", result);
	printf("Data send unsucccessful\n");
  }*/
  sleep(5);
  /*result = syscall(193,rv);
  printf("result = %d\n",result);
  if(result < 0)
         printf("Close Unsuccessful\n"); */

  //printf("calling close from the userspace\n");
  close(ourSocket);
  return 0;

}

