#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "xmdefs.h"
#include "xmerror.h"

void 
xmErrorQuit(char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  fprintf(stderr,"xm: ");
  vfprintf(stderr, fmt, args);
  va_end(args);

  exit(1);
}

void 
xmErrorNoQuit(char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  fprintf(stderr,"xm: ");
  vfprintf(stderr, fmt, args);
  va_end(args);

  fflush(stderr);
}

void 
xmErrorQuitSYS(char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  fprintf(stderr,"xm: ");
  vfprintf(stderr, fmt, args);
  va_end(args);
  perror("perror");

  fflush(stderr);
  exit(1);
}

void 
xmErrorNoQuitSYS(char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  fprintf(stderr,"xm: ");
  vfprintf(stderr, fmt, args);
  va_end(args);
  perror("perror");

  fflush(stderr);
}

void 
xmDEBUG(char *fmt, ...)
{
  va_list args;

  if (!xmdebug)
    return; 

  va_start(args, fmt);
  vfprintf(stdout, fmt, args); 
  if (xmlog)
    vfprintf(fp, fmt, args);
  va_end(args);
  
  fflush(stdout);
}

void 
xmLOG(char *fmt, ...)
{
  va_list args;

  if (!xmlog)
    return;

  va_start(args, fmt);
  vfprintf(fp, fmt, args);
  va_end(args);

}

