/* ************************************************************************
   xmdefs.h
          Has definitions of a lot of stuff
   ************************************************************************ */

#ifndef XMDEFS_H
#define XMDEFS_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>

#include <X11/X.h>
#include <X11/Xproto.h>
#include <X11/Xmd.h>

#define FIRST_PORT    6002
#define LAST_PORT     65000
#define XPORTS_BASE   6000

#define XSERVER  0x1
#define XCLIENT  0x2

#define ALL_SOCKETS   -1
#define MASTER_XSERVER 0    /* Index of master X server */
#define FIRST_SERVER  -1

#define MAX_CONNECTIONS   8
#define MAX_SESSIONS      16
#define MAXHOSTNAMELENGTH 256

#define SERVER_HEADER_SIZE 32
#define CLIENT_HEADER_SIZE 4
#define SERV_SIZE_OFFSET 4
#define CLI_SIZE_OFFSET  2
#define SEQ_NUM_OFFSET 2

#define MAX_PACKETS 2048
#define ATOMS_TABLE_SIZE 256

#define XSERVER_ERROR 0
#define XSERVER_REPLY 1

#define MIN(x,y) ((x) < (y))?(x):(y)
#define ALIGN4(data)  (((data) & 0x3) == 0? (data):((data)+(0x4-((data) & 0x3))))
#define GETCARD8(ptr)  *((CARD8  *) (ptr))
#define GETCARD16(ptr) *((CARD16 *) (ptr))
#define GETCARD32(ptr) *((CARD32 *) (ptr))

#define BUFSIZE (65535 << 2)

typedef enum { FALSE, TRUE } Boolean;
enum { VERBATIM, ALL_SERVERS, SLAVE_SERVERS_ONLY };
enum { FIRST_TIME, NOT_FIRST_TIME };

/* This structure holds information describing the X server to which a
   connection was made.  */

typedef struct {
  xDepth *depth;
  xVisualType *list_visual_type;
} ListxDepth;
 
typedef struct {
  xWindowRoot *window_root;
  ListxDepth *list_xdepth;
} ListxWindowRoot;
  
typedef struct { 
  xConnSetupPrefix *prefix;
  xConnSetup    *setup;
  xPixmapFormat *pixmap_formats;
  ListxWindowRoot *list_xwindow_root;
} ServerParams;

/* This structure holds inet information about each X server the 
   multiplexer connects to */

typedef struct {
  char *xserver_name;               /* Returned value from gethostbyname() */
  struct sockaddr_in xserv_address; /* inet address of X server */
  int port;                         /* Port number to which to talk to */
  int socketd;                      /* Socket descriptor */
  unsigned int max_req_len;
  ServerParams *serv_info;
  unsigned char shift; /* Holds number of trailing zeroes in the Resource
                          ID mask.  Used for Resource ID mapping */
  Atom *atoms;
  int size_atoms;
} XServer;

/* This structure holds inet information about each X client connecting 
   to a multiplexer */

typedef struct {
  char *xclient_name;                 /* Returned value from gethostbyname() */
  struct sockaddr_in xclient_address; /* inet address of X client */
  int socketd;                        /* Socket descriptor */
  CARD32 sequence_num;
} XClient;

typedef struct {
  CARD32 seq_num;       /* Used to keep track of reply having a
                           particluar sequence number */
  CARD8  request_type;  /* The type of request for which we are
                           awaiting a reply */
  CARD8  num_replied;   /* Number of servers that have not replied */
} AwaitReply;
  
/* This structure holds information about the socket on which the multiplexer
   listens for clients */
typedef struct {
  int xm_socket;                      /* Socket descriptor on which X 
                                         multiplexer is waiting for clients */
  struct sockaddr_in xm_address;      /* Address type, inet address info
                                         of X multiplexer */
  int xm_port;                        /* Port number on which xm listens */
} XMDescriptor;

/* This structure is used to map socket numbers to session ids */
typedef struct {
  short session_id;  /* Session id */
  unsigned char type; /* Server or Client */
} SocketTable;

/* This structure holds information about each session the X multiplexer 
   handles.  There can be an X client that connects and a set of
   X servers to which the multiplexer connects. */

typedef struct {
  int num_xservers;                 	/* Number of X servers to which we 
                                         are connected */
  XServer *xservers[MAX_CONNECTIONS]; /* Information about each X server */

  XClient *xclient;                   /* Information about the X client */
  char *buffer;                       /* Buffer to hold data being 
                                         transferred */
  unsigned int curr_buffer_len;       /* Length of the buffer */
  unsigned int max_buffer_len;        /* Maximum length of the buffer */
  unsigned int offsets[MAX_PACKETS];  /* Offsets of start of the
                                         packets currently in the buffer */
  int num_packets;                 		/* Number of packets */
	CARD16 seq_num_last_processed;      /* Sequence number of last request
																				 processed */
  int num_await;                      /* Number of requests for which we are
                                         waiting for replies */
  int await_table_size;
  AwaitReply *await;
  Atom cache_atoms[MAX_CONNECTIONS];  /* Atoms from different servers that 
                                         need to be mapped to the same atom
                                         of the master server. They are stored 
                                         temporarily in this until we have
                                         replies from all servers */
                                        
  short session_id;                   /* Session id of "this" session */
  short ReSize;
  char *ResizeReqBuf;
  CARD32 numFakeReqs;                 /* Number of fake requests */
} XMSession;

/* Structure to return list of expose events */
typedef struct {
  char *buffer;
  unsigned int length;
} EventList;

Boolean xmConnectToServer(XServer *, int, struct hostent *);
Boolean xmGetServerPort(char *, char *, int *);
int xmStartServerSession(char **, register XMSession *);
void xmMultiplexer(char **);
void xmInitialize(register XMSession *);
int  xmAcceptClientConnection(register XMSession *, XMDescriptor *);
void xmCloseClientConnection(register XMSession *);
void xmCloseServerConnection(register XMSession *, int);
int xmFDInit(register XMSession *, fd_set *, int);
void xmMultiCast(register XMSession *, int);
void xmCloseAll(XMSession *);
void xmConnectToHostXServer();
int xmCompleteConnection(register XMSession *);
void xmAnalyze(register XMSession *, int, int);
void xmMakeConfWinPkt(register XMSession *);
EventList *xmMapResIDsAtoms(register XMSession *, int, int, int, Atom *,int);
void xmGetAtomsList(XMSession *,Atom **,int *);
void xmPutAtoms(register XMSession *);
void xmErrorQuit(char *,...);
void xmErrorNoQuit(char *,...);
void xmErrorQuitSYS(char *,...);
void xmErrorNoQuitSYS(char *,...);
void xmDEBUG(char *, ...);
void xmLOG(char *, ...);
void xmExit(XMSession *);
int  xmSleep(int);
int  xmReadServer(register XMSession *, int);
int  xmReadClient(register XMSession *);
struct hostent *xmGetHostInfo(char *);
void writeall(char *, int, int, int);

extern int xmerror;
extern int xmdebug;
extern int xmlog;
extern int xserver_port;
extern char xmByteOrder;
extern XMSession *ss;
extern XServer *host_xserver;
extern char *buffer;
extern FILE *fp;
extern FILE *atm;

#endif
