// <html><body><h1>Copyright Notice</h1>
//    package pat and pat.apps by Steven R. Brandt, all rights reserved.<br>
//    Copyright 1997<br>
//    release 1.0<br>
//    web site:  http://www.win.net/~stevesoft/pat<br>
//    email:  sbrandt@stevesoft.win.net
// <p>
//    By using this software you agree to abide by the limitations of
//    this copyright notice.
// <p>
//    You may not modify this notice, nor any of the object code or
//    source code that it applies to.
// <p>
//    This software comes without express or implied warranty.
//    No claim is made about the suitability of this software for
//    any purpose and neither I nor SteveSoft shall be liable for
//    damages suffered by the user of this software.
// <p>
//    This software is distributed as shareware.  It may
//    be distributed freely as long as this notice is installed in
//    a prominent place and the person or company receiving it is clearly
//    notified of the presence and location of this notice, and can easily
//    read its contents.
// <p>
//    This software may be used in one of two ways:
//    <ol>
//    <li> Programming and development, as a software library:
// 	  If you are compiling and developing software with package
// 	  pat, you may use it if you meet one of the criteria below:
// 	<ol>
// 	<li> You are a non-profit or educational institution.
// 	<li> You are using it for a trial period of one month or less.
// 	<li> You have purchased a license.
// 	</ol>
//    <li> From within a registered application program:  In this
// 	case, no license need be purchased.  The program should contain
// 	a message which is displayed either at startup or from within
// 	an "About" menu item which says that "package pat was licensed
// 	for use by this application."
//    </ol>
// <p>
//    Registration: This costs $10.00 per installation ($25.00 per
//    installation on a distributed file system such as AFS or NFS).
//    Registration entitles you to a copy of ReGameDes, the Regular
//    Expression game designer, and the right to use this software to
//    develop, distribute, and sell software that uses this package as
//    noted above.  If you want to register, please mail
//    a check to Steve Brandt, c/o Lola Peterson, P.O. Box 482 Tioga,
//    PA 16946, USA.  Please include your email address in the memo line,
//    and also send me an email message which contains the check number
//    and the number of machines you are licensing.  A receipt will be
//    sent upon request, but normally you should consider your cancelled
//    check to be your receipt.
// <p>
//    Source will be made available for $50.00.  This does not entitle
//    redistribution of the source to other persons or organizations.
//    It is to be kept confidential.  A source license may be purchased
//    on behalf of another person or organization, but that person or
//    organization must, in turn, agree to abide by the terms of this notice.
// <p>
//    Please contact me if you do not feel my price or usage restrictions
//    are not adequate for your needs, or if for some reason you are unable
//    to pay by check.  I am eager to make sales, and am friendly.
// <p>
//    Happy computing!
// <p>
// </body></html>
package pat.apps;

import pat.Regex;
import java.io.*;
import java.awt.*;

/** A graphical-interfaced program to search the contents of files
in the current directory. */
public class guigrep {
	static class grepFrame extends Frame {
		TextField t1,t2;
		ColorText t3;
		Regex spat,dpat;
		grepFrame() {

			// A very basic menu....
			MenuBar mb = new MenuBar();
			Menu mf = new Menu("&Menu");
			mf.add(new MenuItem("&Exit") {
				public boolean postEvent(Event e) {
						System.exit(0);
						return true;
				}
			});
			mb.add(mf);
			mf.add(new MenuItem("&About"));
			setMenuBar(mb);

			// do the layout...
			GridBagLayout gb = new GridBagLayout();
			setLayout(gb);
			GridBagConstraints gc = new GridBagConstraints();

			Label srchpat = new Label("search pattern");
			gc.gridwidth = gc.gridheight = 1;
			gc.fill = gc.HORIZONTAL;
			gc.weightx = 0.0; gc.weighty = 0.0;
			gc.gridx = 0; gc.gridy = 0;
			gb.setConstraints(srchpat,gc);
			add(srchpat);

			t1 = new TextField("");
			gc.weightx = 1.0;
			gc.gridx = 1; gc.gridy = 0;
			gb.setConstraints(t1,gc);
			add(t1);

			Label dirpat = new Label("file pattern");
			gc.gridwidth = gc.gridheight = 1;
			gc.fill = gc.HORIZONTAL;
			gc.weightx = 0.0; gc.weighty = 0.0;
			gc.gridx = 0; gc.gridy = 1;
			gb.setConstraints(dirpat,gc);
			add(dirpat);

			t2 = new TextField("");
			gc.weightx = 1.0;
			gc.gridx = 1; gc.gridy = 1;
			gb.setConstraints(t2,gc);
			add(t2);

			t3 = new ColorText();
			gc.gridwidth = 2;
			gc.fill = gc.BOTH;
			gc.weighty = 1.0;
			gc.gridx = 0; gc.gridy = 2;
			gb.setConstraints(t3,gc);
			add(t3);

			pack();
			resize(200,300);
			show();
		}
		public boolean action(Event e,Object o) {
			if(e.target instanceof Button) return true;
			if(o instanceof String) {
				String s = (String)o;
				if(s.equals("&About")) {
					
					Message m = new Message();
					m.setTitle("About");
					m.addCentered("guigrep");
					m.addCentered("A file search utility");
					m.addCentered("by Steven R. Brandt");
					m.addCentered("Home page at");
					m.addCentered("http://www.win.net/~stevesoft/pat");
					m.addButton("OK");
					m.ask(this);
					return true;
				}
			}
			spat = new Regex(t1.getText());
			spat.optimize();
			dpat = new Regex(t2.getText());
			t3.clear();
			File f = new File(".");
			String[] files = f.list(dpat);
			for(int i=0;i<files.length;i++) try {
				FileReader ff=new FileReader(files[i]);
				BufferedReader bf=new BufferedReader(ff);
				String s = bf.readLine();
				int lno = 1;
				while(s != null) {
					if(spat.search(s)) {
						pat.RegRes r = spat.result();
						ColorLine cl=new ColorLine();
						cl.add(Color.blue,files[i]+" "+lno+
							": ");
						cl.add(Color.black,
							r.left().replace('\t',' '));
						cl.add(Color.red,
							r.substring().replace('\t',' '));
						cl.add(Color.black,
							r.right().replace('\t',' '));
						t3.addColorLine(cl);
					}
					lno++;
					s = bf.readLine();
				}
				bf.close();
			}catch(Throwable t) {}
			repaint();
			return true;
		}
	}
	static Regex pat = null;

	public static void main(String[] unused) {
		grepFrame gf=new grepFrame();
	}
}
