
package Scout;

import java.io.Serializable;

class WordCounterRuleWord implements Serializable {
  
  String word;
  int count;
  
  // Create word with count=1
  protected WordCounterRuleWord(String word) {
    this.word= word;
    count= 1;
  }
  
  // Increment this word's count by one
  void incrementCount() {
    count++;
  }
  
  // Object.toString override
  public String toString() {
    return word + "," + count;
  }
  
  // Return true if the stored word matches the argument word
  boolean equals(String word, boolean matchCase) {
    return matchCase ? this.word.equalsIgnoreCase(word) : this.word.equals(word);
  } 

}
