// VisitRecord.java
// A.L. Borchers, 1997 November
// University of Kentucky Department of Computer Science

// class to store list of sites already visited

package Scout;

import java.io.Serializable;

class VisitRecord implements Serializable {

  // default size of table for storing visit records
  public int initSize= 1000000;

  private int elements= 0;

  Hashlookup h= null;

  protected VisitRecord() {
    h= new Hashlookup(initSize);
  }

  protected void add(String urlStr) {
    elements++;
    h.store(urlStr);
  }

  protected boolean visited(String urlStr) {
    return h.lookup(urlStr);
  }

  public int size() {
    return elements;
  }

}
