// ScoutControls.java
// A.L. Borchers, 1997 November
// University of Kentucky Department of Computer Science

package Scout;

import java.awt.*;

import java.io.IOException;

import java.util.Date;

class ScoutControls extends Frame {

  // The scout we belong to
  Scout scout;

  // buttons on the frame
  Button exitButton= new Button("Exit Scout");
  Button pauseButton= new Button("Pause");
  Button logButton= new Button("Hide Log");

  ScoutControls(Scout scout) {
    super("Scout Controls");
    this.scout= scout;
    setLayout(new FlowLayout());
    add(logButton);
    add(pauseButton);
    add(exitButton);
    pack();
    show();
  }

  public boolean handleEvent(Event e) {
    if (e.id == Event.ACTION_EVENT) {
      if (e.target == exitButton) {
        // if scout is already finished just exit
        if (scout.done) {
          System.exit(0);
        }
        // Otherwise, some clean up is required first
	// invalidate synchronized objects
	scout.urls.done= true;
	scout.buffer.done= true;
	// interrupt and shutdown threads 
	// (interrupt assures loops in synch'ed objects will break)
	for (int i= 0; i < scout.rules.size(); i++) {
	  ((Thread)scout.rules.elementAt(i)).interrupt();
	  ((Thread)scout.rules.elementAt(i)).stop();
	}  
	scout.interrupt();
	scout.stop();
	// Log results obtained so far and write scout's exit notice
	scout.logResults();
	Date d= new Date();
	scout.endTime= d.getTime();
	long runSeconds= (scout.endTime - scout.startTime)/1000;
	scout.logger.log("ScoutControls.handleEvent - Scout shut down manually at " + d.toString() + 
			 " after " + runSeconds/60 + " minutes " + runSeconds%60 + " seconds");
	// Save the cache and state before while exiting
	try {
    scout.saveState();
	  scout.cache.save();
	}
	catch (IOException ioe) {
	  System.err.println("Couldn't save cache...");
	}
	System.exit(0);
      }
      if (e.target == pauseButton) {
	// TODO: don't pause Scout while it's talking to the Net
	// TODO: check for any threads that may have finished before
	//       attempting to suspend/resume them
	if (e.arg.equals("Pause")) {
	  for (int i= 0; i < scout.rules.size(); i++) {
	    ((Thread)scout.rules.elementAt(i++)).suspend();
	  }
	  scout.suspend();
	  pauseButton.setLabel("Resume");
	}
	else {
	  for (int i= 0; i < scout.rules.size(); i++) {
	    ((Thread)scout.rules.elementAt(i++)).resume();
	  }
	  scout.resume();
	  pauseButton.setLabel("Pause");
	}
      }
      if (e.target == logButton) {
	if (e.arg.equals("Hide Log")) {
	  scout.logger.hide();
	  logButton.setLabel("Show Log");
	  return true;
	}
	else {
	  scout.logger.show();
	  logButton.setLabel("Hide Log");
	  return true;
	}
      }
      return false;
    }
    else
      return false;
  }

}
