/*

Results.java
A.L. Borchers, 1997 November
University of Kentucky Department of Computer Science

Class for storing rule results as a hash of vectors of vectors

Structure is:

Table
------------------------------------------------------------------
Key - Vector of result vectors indexed by document number

*/

package Scout;

import java.io.Serializable;

import java.util.Hashtable;
import java.util.Vector;

class Results extends Hashtable implements Serializable {

  // The scout we work for
  transient Scout scout;

  Results(Scout scout) {
    super();
    this.scout= scout;
  }

  protected void setScout(Scout s) {
    scout= s;
  }

  // Put a vector of size 0 or more in the table and notify all threads of the change
  public synchronized void put(Rule r, int docNumber, Vector results) {
    scout.logger.log("Results.put - Storing " + results.size() + 
		     " results for rule " + r.getName() + ", document " + docNumber);
    // Get the previous results for this rule, constructing a vector and adding it to
    // the table if none exists (i.e. first call)
    Vector ruleResults= (Vector)super.get(r.getName());
    if (ruleResults == null) {
      ruleResults= new Vector();
      super.put(r.getName(),ruleResults);
    }
    // insert the new results at document number
    ruleResults.insertElementAt(results,docNumber);
    notifyAll();
  }

  // The get method is synchronized with a wait so that
  // rules which are dependent on output from other rules
  // may be guaranteed access to their results. Note that
  // Rule objects report even if they store an empty vector!
  // POTENTIAL HAZARD: A rule which requests a key that 
  // will never be put into the table (i.e. a key that does
  // not conform to RuleName,SequenceNumber for a RuleName
  // that is active in the current rule set) will wait 
  // forever!!! 
  public synchronized Vector get(Rule r, String key, int docNumber) {
    Vector out= null;
    boolean acquired= false;
    while (!acquired) {
      // while ((out= (Vector)super.get(key)) == null) {
      out= (Vector)super.get(key);
      /*
	if (out == null) {
	  System.err.println("Results.get - " + key + " == null");
	}
	else {
  	  System.err.println("Results.get - " + key + " == " + out.toString() + " (length " + out.size() + ")");
	}
      */
      acquired= out != null && (out.size()-1) >= docNumber;
      if (!acquired) {
	try {
	  // scout.logger.log("Results.get - calling wait on requesting thread " + r.getName());
	  wait();
	}
	catch (InterruptedException e) {
	}
      }
    }
    return (Vector)out.elementAt(docNumber);
  }

}
