// ConfigLoader.java
// A.L. Borchers, October 1997
// File I/O for Config objects

package Scout;

import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.Enumeration;
import java.util.Hashtable;

class ConfigLoader {
  
  String confFile= null;

  Hashtable config= null;

  // No arg constructor 
  ConfigLoader() {
  }

  // Establish object with associated file 
  ConfigLoader(String file) {
    confFile= file;
  }

  public Hashtable load() 
    throws IOException, FileNotFoundException {
      if (confFile == null) 
	throw new IOException("No file specified for loading");
      readFile();
      return config;
  }

  public Hashtable load(String file) 
    throws IOException, FileNotFoundException {
      confFile= file;
      return load();
  }

  private void readFile()
    throws IOException, FileNotFoundException {
      config= new Hashtable();
      BufferedReader reader= new BufferedReader(new FileReader(confFile));
      String line= null, currSection= null;
      while ((line= reader.readLine()) != null) {
	// Throw away comments
	if (line.indexOf("#") >= 0)
	  line= line.substring(0,line.indexOf("#"));
	line= line.trim();
	if (!line.equals("")) {
	  if (line.startsWith("[") && line.endsWith("]")) {
	    currSection= line.substring(1);
	    currSection= currSection.substring(0,currSection.indexOf(']'));
	    if (!config.containsKey(currSection))
	      config.put(currSection,new Hashtable());
	  }
	  else {
	    if (currSection == null)
	      throw new IOException("Non empty line (" + line +
				    ") occured outside of section delimiter");
	    if (line.indexOf('=') <= 0)
	      throw new IOException("Malformed key=val pair (" + line + ")");
	    String key= line.substring(0,line.indexOf('='));
	    String val= line.substring(line.indexOf('=')+1);
	    ((Hashtable)config.get(currSection)).put(key,val);
	  }
	}
      }
  }

  public void save() 
    throws IOException {
      if (confFile == null) 
	throw new IOException("No file specified for saving");
      BufferedWriter writer= new BufferedWriter(new FileWriter(confFile));
      Enumeration sections= config.keys();
      while (sections.hasMoreElements()) {
	String sectionName= (String)sections.nextElement();
	writer.write("[" + sectionName + "]\n");
	Hashtable section= (Hashtable)config.get(sectionName);
	Enumeration keys= section.keys();
	while (keys.hasMoreElements()) {
	  String key= (String)keys.nextElement();
	  String val= (String)section.get(key);
	  writer.write(key + "=" + val + "\n");
	}
      }
      writer.close();
  }

  public void save(String file) 
    throws IOException {
      confFile= file;
      save();
  }

}
