// Config.java
// A.L. Borchers, October 1997
// Implements a configuration as a two tier Hashtable
// of key=val pairs ordered by sections

package Scout;

import java.io.IOException;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;


public class Config extends ConfigLoader {

  // No arg constructor
  public Config() {
    super();
  }

  // Construct by loading the specified file
  public Config(String file) 
    throws IOException {
      super(file);
      load();
  }

  // Set value by section,key
  public void set(String section, String key, String value) {
    // Add hashtable for section if it's not there yet
    if (!config.containsKey(section))
      config.put(section,new Hashtable());
    // Add the nv pair under the appropriate section
    ((Hashtable)config.get(section)).put(key,value);
  }

  // Return a value for section,key pair
  public String get(String section, String key) {
    // Get the section
    Hashtable sectionTable= (Hashtable)config.get(section);
    if (sectionTable == null) return null;
    // Return key's value in section
    return (String)sectionTable.get(key);
  }

  public void addSection(String sectionName) {
    if (config.containsKey(sectionName)) return;
    config.put(sectionName,new Hashtable());
  }

  public void removeSection(String sectionName) {
    config.remove(sectionName);
  }

  public void remove(String section, String key) {
    Hashtable h= (Hashtable)config.get(section);
    if (h == null) return;
    h.remove(key);
  }

  // Return sorted array of section keys
  public String[] sections() {
    return sortKeys(config.keys());
  }

  // Return sorted array of keys from section
  public String[] keys(String section) {
    Hashtable h= (Hashtable)config.get(section);
    return h == null ? null : sortKeys(h.keys());
  }

  // Sort an enumeration of strings into a sorted array of strings
  public String[] sortKeys(Enumeration e) {
    Vector v= new Vector();
    while (e.hasMoreElements()) {
      String nextKey= (String)e.nextElement();
      if (v.isEmpty())
	v.addElement(nextKey);
      else {
	int i;
	for (i= 0; i < v.size() && nextKey.compareTo((String)v.elementAt(i)) > 0; i++);
	v.insertElementAt(nextKey,i);
      }
    }
    String[] result= new String[v.size()];
    v.copyInto(result);
    return result;
  }

  public void dump() {
    String out= "Configuration File: " + confFile +"\n";
    String[] sectionKeys= sections();
    for (int i= 0; i < sectionKeys.length; i++) {
      out+= "[" + sectionKeys[i] + "]\n";
      String[] keys= keys(sectionKeys[i]);
      for (int j= 0; j < keys.length; j++)
	out+= keys[j] + ": " + get(sectionKeys[i],keys[j]) + "\n";
    }
    System.out.println(out);
  }
  
}
