/*

EntityTable.java
A.L. Borchers, 1997 November
University of Kentucky Department of Computer Science

Constructs a hashtable object for dereferencing named SGML 
character entities and retrieving entities for the characters

Note: Characters are stored as strings of length 1

*/

package SGMLKit; 

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.Hashtable;
import java.util.StringTokenizer;

public class EntityTable {

  // default file for entity data
  public static final String defaultEntityFile= "entities.txt";

  // Hastable for storing entity data
  private Hashtable table= new Hashtable();

  // load the default entity file
  public EntityTable()
    throws FileNotFoundException, IOException {
      this(defaultEntityFile);
  }

  // load entity table from the specified file
  // Entity file format is LBL:
  // entity\tchar(\tDesc)?
  // Descriptions are not stored
  public EntityTable(String fileName) 
    throws FileNotFoundException, IOException {
      BufferedReader reader= 
	new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
      String line= null;
      while ((line= reader.readLine()) != null) {
	line= line.trim();
	if (!line.equals("") && !line.startsWith("#")) {
	  StringTokenizer st= new StringTokenizer(line);
	  if (st.countTokens() < 2) 
	    throw new IOException("Invalid entity file");
	  String entity= st.nextToken();
	  String character= st.nextToken();
	  table.put(entity,character);
	  table.put(character,entity);
	}
      }
      reader.close();
      // since nbsp can't be encoded in the entity file format,
      // it's manually inserted
      table.put("nbsp"," ");
      table.put(" ","nbsp");
  }

  // expand the given entity
  public String map(String entity) {
    return (String)table.get(entity);
  }

  // stub
  public static void main(String[] args) {
    try {
      EntityTable table= (args.length > 0) ? new EntityTable(args[0]) : new EntityTable();
      BufferedReader reader= new BufferedReader(new InputStreamReader(System.in));
      String entity= null;
      System.out.print("Entity or character for translation: ");
      while (!(entity= reader.readLine()).equals("")) {
	System.out.println(table.map(entity));
	System.out.print("Entity or character for translation: ");
      }
      reader.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

}

