package Logger;

import java.io.OutputStream;
import java.io.FileOutputStream;

import java.awt.*;

//
//
// WindowedLogger
//
//
public class WindowedLogger extends Logger {

  public static final int defaultRows= 20;
  public static final int defaultCols= 80;
  public static final String defaultFrametitle= "Activity Log";
  public static final OutputStream defaultOutputStream= System.out;
  
  String[] messages;
  int rows, cols, linesWritten;
  Frame frame;
  TextArea textUpdate;
  
  public WindowedLogger() {
    this(defaultFrametitle,defaultOutputStream,defaultRows,defaultCols);
  }
  
  public WindowedLogger(OutputStream os) {
    this(defaultFrametitle,os,defaultRows,defaultCols);
  }
  
  public WindowedLogger(String frameTitle, OutputStream os) {
    this(frameTitle,os,defaultRows,defaultCols);
  }
  
  public WindowedLogger(String frameTitle, OutputStream os, int rows) {
    this(frameTitle,os,rows,defaultCols);
  }
  
  public WindowedLogger(String frameTitle, OutputStream os, int rows, int cols)
  {
    super(os);
    this.rows= rows;
    this.cols= cols;
    linesWritten= 0;
    messages= new String[rows];
    frame= new Frame(frameTitle);
    textUpdate= new TextArea(rows,cols);
    textUpdate.setEditable(false);
    frame.add("Center",textUpdate);
    frame.pack();
    frame.show();
  }
  
  // Show the graphical log
  public void show() {
    frame.show();
  }
  
  // Hide the graphical log
  public void hide() {
    frame.hide();
  }
  
  // Log the message on the outstream by calling super, then
  // update the graphical log with the new message
  public void log(String message) {
    super.log(message);
    if (linesWritten < rows) {
      messages[linesWritten]= message;
    }
    else {
      // Scroll the text up
      for (int i= 0; i < rows-1; i++) {
	messages[i]= messages[i+1];
      }
      // Add the new message at the end
      messages[rows-1]= message;
    }
    updateWindow();
    linesWritten++;
  }
  
  // Update the graphical log
  private void updateWindow() {
    String textOut= new String();
    for (int i= 0; i < messages.length; i++) {
      if (messages[i] == null) break;
      textOut= textOut + messages[i] + "\n";
    }
    textUpdate.setText(textOut); 
  }

  public static void main(String[] args) {
    try {
      FileOutputStream out= new FileOutputStream("wltest.log");
      WindowedLogger wl= new WindowedLogger("Windowed Logger Test",out,4,80);
      wl.show();
      for (int i= 0; i < 10; i++) {
	wl.log("Message #" + i);
    	System.in.read(new byte[256]);
      }
      out.close();
      System.exit(0);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
}

