/*
* PackageListRule.java
* A.L. Borchers, 1998
*
* Rule for reading a package index file (URLs terminating in packages.html).
* Feeds Scout's URL queue with the URLs of each discovered package index.
* 
*/

package JavaDoc;

import SGMLKit.Tag;

import Scout.*;

import java.net.URL;

import java.util.Vector;

public class PackageListRule extends Rule {
	
	public static final boolean debug= false;
	
	public PackageListRule(Scout scout, RuleHash rh)
		throws RuleFormatException {
		super(scout,rh);
	}
	
	public synchronized void processDoc() {
		
		super.processDoc();
		
		try {
			// Sanity check the URL
			if (!doc.getURL().toString().endsWith("/packages.html")) {
				throw new Exception("Failed to find expected URL termination /packages.html");
			}
			// Get the text and tags of the document
			String docText= doc.getText();
			Vector docTags= doc.getTags();
			// use for bounding tagged regions
			int open= 0, close= 0;
			// The level one header should include an image with alternate text 
			// of "Package Index" (quotes literal)
			open= Tag.locateTag(docTags,"h1",open);
			close= Tag.locateTag(docTags,"/h1",open+1);
			open= Tag.locateTag(docTags,"img",open+1);
			String sanityCheck= ((Tag)docTags.elementAt(open)).getUnquoted("alt");
			if (!sanityCheck.equals("Package Index")) {
				throw new Exception("Failed to find expected indicator string " +
					"\"Package Index\"");
			}
			// ok - we should now be at the beginning of a menuc where each li
			// is a link to a package index file
			open= Tag.locateTag(docTags,"menu",close+1);
			close= Tag.locateTag(docTags,"/menu",open+1);
			if (open == -1 || close == -1) {
				throw new Exception("Failed to find expected menu of package references");
			}
			// now we can grab up the <li>s
			while (open > 0 && open < close) {
				open= Tag.locateTag(docTags,"li",open+1);
				if (open > 0 && open < close) {
					open++;
					Tag href= (Tag)docTags.elementAt(open);
					if (!href.getIdentifier().equals("a")) {
						throw new Exception("Failed to find expected link to package file");
					}
					// get the relative url of the package index
					String relativeURL= href.getUnquoted("href");
					scout.urls.append(new URL(doc.getURL(),relativeURL));
				}
			}
		}
		catch (Exception e) {
			scout.logger.log(getName() + ".processDoc - " + doc.getURL().toString() + 
				" does not appear to be a package list file: " +
				e.toString());
			if (debug) {
				e.printStackTrace();
			}
			return;
		}
		
		
		
		
	}
	
	
	
}
