/*
 * @(#)AuthorizationHandler.java			0.2-2 23/03/1997
 *
 *  This file is part of the HTTPClient package 
 *  Copyright (C) 1996,1997  Ronald Tschalaer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 *  MA 02111-1307, USA
 *
 *  For questions, suggestions, bug-reports, enhancement-requests etc.
 *  I may be contacted at:
 *
 *  ronald@innovation.ch
 *  Ronald.Tschalaer@psi.ch
 *
 */

package HTTPClient;


/**
 * This is the interface that an Authorization handler must implement.
 *
 * @version	0.2 (bug fix 2)  23/03/1997
 * @author	Ronald Tschal&auml;r
 */

public interface AuthorizationHandler
{
    /**
     * getAuthorization must return a structure containing either the
     * authorization string (for the "basic" scheme), the required
     * authorization parameters, or null if no info was given.
     *
     * @param challenge the parsed challenge from the server; the host,
     *                  port, scheme, realm and params are set to the
     *                  values given by the server in the challenge.
     * @return a structure containing the necessary authorization info,
     *         or null. The necessary info includes the host, port,
     *         scheme and realm as given in the <var>challenge</var>
     *         parameter, plus either the cookie or any necessary params.
     * @exception AuthTypeNotImplementedException if the authorization scheme
     *             in the challenge cannot be handled.
     */
    public abstract AuthorizationInfo
	    getAuthorization(AuthorizationInfo challenge)
	    throws AuthTypeNotImplementedException;
}

