/*
 * Search.java
 * A.L. Borchers, 1998
 *
 * Algorithms for searching general trees
 * 
 */


package ADT;

public class Search {

  public static final int BFS= 0;
  public static final int DFS= 1;

  public static Node BFSearch(Node root, Object data) {
    Queue q= new Queue();
    q.append(root);
    return searchBFS(q,data);
  }
  
  private static Node searchBFS(Queue q, Object data) {
    if (q.isEmpty()) {
      return null;
    }
    Node n= (Node)q.remove();
    if (n.data.equals(data)) {
      return n;
    }
    for (int i= 0; i < n.children.size(); i++) {
      q.append(n.children.getSibling(i));
    }
    return searchBFS(q,data);
  }

  public static Node DFSearch(Node root, Object data) {
    Stack s= new Stack();
    s.push(root);
    return searchDFS(s,data);
  }

  private static Node searchDFS(Stack s, Object data) {
    if (s.isEmpty()) {
      return null;
    }
    Node n= (Node)s.pop();
    if (n.data.equals(data)) {
      return n;
    }
    for (int i= 0; i < n.children.size(); i++) {
      s.push(n.children.getSibling(i));
    }
    return searchDFS(s,data);
  }




}
