package rbs.util;

import java.io.IOException;
import org.xml.sax.*;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.helpers.DefaultHandler;

public class LogReader{
	public static void main(String[] args){
		new LogReader("rbs.log");
	}
	
	public LogReader(String file){
		try{
			XMLReader parser = XMLReaderFactory.createXMLReader();
			parser.setContentHandler(new LogHandler());
			parser.parse(file);
		} catch(SAXException e){
			e.printStackTrace();
		} catch(IOException e){
			e.printStackTrace();
		}
	}

	class LogHandler extends DefaultHandler{
		private boolean level = false;
		private boolean bclass = false;
		private boolean message = false;

		public LogHandler() throws SAXException{
			super();
		}

		public void startElement(String nsURI, String localName, String rawName,
			Attributes attributes) throws SAXException {
			if(rawName.equalsIgnoreCase("level")){
				level = true;
			}
			if(rawName.equalsIgnoreCase("class")){
				bclass = true;
			}
			if(rawName.equalsIgnoreCase("message")){
				message = true;
			}
		}

		public void characters(char[] chars, int start, int length){
			if(level){
				System.out.print(new String(chars, start, length));
				System.out.print(" - ");
				level = false;
			}
			if(message){
				System.out.println(new String(chars, start, length));
				message = false;
			}
			if(bclass){
				bclass = false;
			}
		}
	}
}
