package rbs.ui;

import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class PlaybackGUI extends GraphicalInterface{
	private static Playback playback;

	public PlaybackGUI(Playback playback){
		super("Playback Controls");
		PlaybackGUI.playback = playback;
	}

	public void initInterface(){
		super.initInterface();
		//need images for buttons
		//TODO: Refactor this portion
		JButton beginButton = new JButton("Begin");
		beginButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				PlaybackGUI.playback.begin();
			}
		});
		super.addComponent(beginButton);

		JButton rewindButton = new JButton("Rew");
		rewindButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				PlaybackGUI.playback.rewind();
			}
		});
		super.addComponent(rewindButton);

		JButton pauseButton = new JButton("Pause");
		pauseButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				PlaybackGUI.playback.pause();
			}
		});
		super.addComponent(pauseButton);

		JButton playButton = new JButton("Play");
		playButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				PlaybackGUI.playback.play();
			}
		});
		super.addComponent(playButton);

		JButton stopButton = new JButton("Stop");
		stopButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				PlaybackGUI.playback.stop();
			}
		});
		super.addComponent(stopButton);

		JButton ffButton = new JButton("FF");
		ffButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				PlaybackGUI.playback.ff();
			}
		});
		super.addComponent(ffButton);

		JButton endButton = new JButton("End");
		endButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				PlaybackGUI.playback.end();
			}
		});
		super.addComponent(endButton);
	}
}
