package rbs.ui;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.JComponent;
import java.awt.FlowLayout;

public class GraphicalInterface extends UserInterface implements Runnable{
	private JFrame panel;
	private String name;

	public GraphicalInterface(String name){
		this.name = name;
	}

	public void initInterface(){
		panel = new JFrame(name);
		panel.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		panel.getContentPane().setLayout(new FlowLayout());
	}

	public void start(){
		panel.pack();
		panel.setVisible(true);
		SwingUtilities.invokeLater(this);
	}

	public void addComponent(JComponent component){
		panel.getContentPane().add(component);
	}

	public void close(){
		if(panel != null)
			panel.dispose();
	}

	public void run(){}
}
