package rbs.sim;

import javax.vecmath.Vector3f;

public abstract class TimeStepSim extends SimulationThread{
	private int numTimeSteps;
	private float timeStepSize;
	private float timeStep;

	public TimeStepSim(String fileName, int numTimeSteps, float timeStepSize,
		boolean pauseOnCollision, Vector3f gravity, boolean isGravityForce){
		super(fileName, pauseOnCollision, gravity, isGravityForce);
		this.timeStep = timeStepSize;
		this.numTimeSteps = numTimeSteps;
		this.timeStepSize = timeStepSize;
		super.setEndTime(numTimeSteps * timeStepSize);
	}

	public synchronized int getNumTimeSteps(){
		return this.numTimeSteps;
	}

	public synchronized float getTimeStepSize(){
		return this.timeStepSize;
	}

	private synchronized void setNumTimeSteps(int numTimeSteps){
		this.numTimeSteps = numTimeSteps;
		logger.config("Number of Time Steps " + numTimeSteps);
	}

	private synchronized void setTimeStepSize(float timeStepSize){
		this.timeStep = timeStepSize;
		this.timeStepSize = timeStepSize;
		logger.config("Time Step Size " + timeStepSize);
	}

	protected synchronized void rollbackTime(){
		this.setCurrentTime(this.getCurrentTime() - this.timeStep);
		this.timeStep = this.timeStep / 2.0f;
	}

	protected synchronized void resumeTime(){
		this.timeStep = this.timeStepSize;
	}

	protected synchronized void advanceTime(){
		float timeToEnd = super.getEndTime() - super.getCurrentTime();
		ForceEvent nextEvent = super.getEventQueue().peek();

		if(nextEvent != null && 
			nextEvent.getTime() < super.getCurrentTime() + this.timeStep){
			super.setCurrentTime(nextEvent.getTime());
		}
		else if(timeToEnd > 0.0f && timeToEnd <= this.timeStep){
			super.setCurrentTime(super.getEndTime());
		}
		else{
			float end = super.getCurrentTime() +  this.timeStep;
			super.setCurrentTime(super.getCurrentTime() + this.timeStep);
		}

		logger.info("Current Sim Time: " + super.getCurrentTime());
	}
}
