package rbs.sim;

import javax.vecmath.Vector3f;

public class SimulationThreadFactory{
	public static final String PREDICT_TIME_STEP = "predict_time_step";
	public static final String REACT_TIME_STEP = "react_time_step";
	public static final String PREDICT_EVENT = "predict_event";
	//public static final String REACT_EVENT = "react_event";

	public static SimulationThread newSimulationThread(String type,
		String fileName, int numTimeSteps, float timeStepSize,
		boolean pauseOnCollision, Vector3f gravity, boolean isGravityForce){

		SimulationThread st = null;
		if(type.equals(PREDICT_TIME_STEP)){
			st = new PredictTimeStepSim(fileName, numTimeSteps, timeStepSize,
				pauseOnCollision, gravity, isGravityForce);
		}
		else if(type.equals(REACT_TIME_STEP)){
			st = new ReactTimeStepSim(fileName, numTimeSteps, timeStepSize,
				pauseOnCollision, gravity, isGravityForce);
		}
		return st;
	}

	public static SimulationThread newSimulationThread(String type,
		String fileName, float endTime, boolean pauseOnCollision,
		Vector3f gravity, boolean isGravityForce){
		
		SimulationThread st = null;
		if(type.equals(PREDICT_EVENT)){
			st = new PredictEventSim(fileName, endTime, pauseOnCollision,
				gravity, isGravityForce);
		}
		return st;
	}
}
