package rbs.sim;

public class Object3DFactory{
	public final static String SPHERE_TYPE = "sphere";
	public final static String PLANE_TYPE = "plane";
	private final static String CHECKER_PLANE_TYPE = "checker_plane";

	public static Object3D newObject3D(String type){
		Object3D newObj = null;
		type = type.toLowerCase();
		if(type.equals(SPHERE_TYPE)){
			newObj = new Sphere();
			newObj.setType(SPHERE_TYPE);
		}
		if(type.equals(PLANE_TYPE) || type.equals(CHECKER_PLANE_TYPE)){
			newObj = new Plane();
			newObj.setType(PLANE_TYPE);
		}
		return newObj;
	}
}
