package rbs.sim;

import java.lang.CloneNotSupportedException;
import javax.vecmath.Vector3f;
import javax.vecmath.Point3f;

public class NormalForce extends Force implements Cloneable{
	private Vector3f normal;

	public NormalForce(Vector3f force, Point3f origin, Vector3f normal,
			boolean acceleration){
		super(force, origin, Float.MAX_VALUE, acceleration);
		this.normal = normal;
		this.normal.normalize();
	}

	//normalize force vector
	public boolean apply(float timeDelta, Object3D obj){
		obj.getLogger().fine("Normal Force");
		//first apply the force
		super.apply(timeDelta, obj);

		//XXX:should this even be done here it just saves us having to rollback
		//TODO: formally make a force and add it to the queue for the object
		//		or later calculations will be thrown off
		//	in the next frame
		//if there is still velocity into the plane
		float normVelocity = obj.normalVelocity(this.normal);
		obj.getLogger().fine("Velocity of object in direction of normal = " +
			normVelocity);

		if(normVelocity < 0.0f){  //object is going into the plane
			//we need to reflect it by multiplying by -1
			Vector3f reflectVector = new Vector3f(this.normal);
			reflectVector.scale(normVelocity * -2.0f);
			obj.getVelocity().add(reflectVector);
			obj.getLogger().fine("Velocity of object after reflection = " +
				obj.getVelocity());
		}

		return true;
	}

	public Object Clone() throws CloneNotSupportedException{
		return super.clone();
	}
}
