package rbs.sim;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.lang.CloneNotSupportedException;
import java.util.Hashtable;

//NOT THREAD SAFE
public class MaterialStore{
	private static MaterialStore instance;

	private Hashtable<String, Material> materialStore;

	private MaterialStore(){
		materialStore = null;
	}

	public static MaterialStore getInstance(){
		if(instance == null){
			instance = new MaterialStore();
		}
		return instance;
	}

	public Material getMaterial(String name){
		if(materialStore != null)
			return materialStore.get(name);
		else
			return null;
	}

	private Material addMaterial(String name){
		if(materialStore == null)
			return null;

		Material material = new Material(name);
		materialStore.put(name, material);
		return material;
	}

	public void loadFromFile(String fileName){
		BufferedReader input = null;
		try{
			input = new BufferedReader(new FileReader(fileName));
		} catch(FileNotFoundException e){
			System.out.println("ERROR: Material file not found");
			return;
		}

		try{
			this.loadFromFile(input);
		} catch(IOException e){
			System.out.println("ERROR: Could not read Material file.");
			return;
		}

		try{
			input.close();
		} catch(IOException e){
			System.out.println("WARNING: Unable to close material file.");
		}
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		//read in the number of materials
		int numMaterials = Integer.parseInt(input.readLine());
		materialStore = new Hashtable<String, Material>(numMaterials);
		//load each material
		for(int mat = 0; mat < numMaterials; mat++){
			Material material = this.addMaterial(input.readLine());
			material.loadFromFile(input, numMaterials);
		}
	}
}
