package rbs.sim;

public abstract class ForceEvent implements Comparable{
	private float time;
	private Object3D obj;

	public void setObject(Object3D obj){
		this.obj = obj;
	}

	public Object3D getObject(){
		return this.obj;
	}

	public void setTime(float time){
		this.time = time;
	}

	public float getTime(){
		return this.time;
	}

	public int compareTo(Object o) throws ClassCastException{
		if(!(o instanceof ForceEvent))
			throw new ClassCastException();

		ForceEvent fe = (ForceEvent)o;
		if(fe.getTime() == this.time)
			return 0;
		else if(fe.getTime() < this.time)
			return -1;
		else
			return 1;
	}

	abstract void handleIt();
}
