package rbs.sim;

import java.lang.CloneNotSupportedException;
import javax.vecmath.Vector3f;
import javax.vecmath.Point3f;
import java.lang.Float;

public class ConstantForce extends Force implements Cloneable{

	public ConstantForce(Vector3f force, Point3f origin, boolean acceleration){
		super(force, origin, Float.MAX_VALUE, acceleration);
	}

	public ConstantForce(Vector3f direction, float magnitude, Point3f origin,
			boolean acceleration){
		super(direction, magnitude, origin, Float.MAX_VALUE, acceleration);
	}

	//Constant force class overwrite and always return false
	public boolean apply(float timeDelta, Object3D obj){
		super.apply(timeDelta, obj);
		this.setDuration(Float.MAX_VALUE);
		return false;
	}

	public Object Clone() throws CloneNotSupportedException{
		return super.clone();
	}
}
