package rbs.render;

import java.io.Serializable;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.CloneNotSupportedException;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class Sphere extends Renderable implements Cloneable, Serializable{
	private float radius;

	public Sphere(){
		this.radius = 1.0f;
	}

	public float getRadius(){
		return this.radius;
	}

	public void setRadius(float radius){
		this.radius = radius;
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		super.loadFromFile(input);
		this.setRadius(Float.parseFloat(input.readLine()));
	}

	public Object clone() throws CloneNotSupportedException{
		return super.clone();
	}

	//TODO: need a detail setting
	public void renderOpenGL(GL gl, GLU glu, GLUquadric gluQuad){
		gl.glTranslatef(this.getX(), this.getY(), this.getZ());
		gl.glRotatef(this.getRoll(), ROLL_X, ROLL_Y, ROLL_Z);
		gl.glRotatef(this.getPitch(), PITCH_X, PITCH_Y, PITCH_Z);
		gl.glRotatef(this.getYaw(), YAW_X, YAW_Y, YAW_Z);
		glu.gluSphere(gluQuad, this.getRadius(), 32, 32);
	}
}
