package rbs.render;

import java.lang.reflect.Constructor;
import java.lang.ClassNotFoundException;
import java.lang.NoSuchMethodException;
import java.lang.InstantiationException;
import java.lang.IllegalAccessException;
import java.lang.reflect.InvocationTargetException;

public abstract class RenderableFactory{
	private final static String SPHERE_FACTORY = "sphere";
	private final static String PLANE_FACTORY = "plane";
	private final static String CHECKER_PLANE_FACTORY = "checker_plane";
	private final static String DECO_SUFFIX = "Decorator";
	private final static String CLASS_PREFIX = "rbs.render.";

	protected final static String SEPERATOR = ":";

	public static RenderableFactory getFactory(String type){
		RenderableFactory rf = null;
		type = type.toLowerCase();
		if(type.equals(SPHERE_FACTORY)){
			rf = new SphereFactory();
		}
		else if(type.equals(PLANE_FACTORY)){
			rf = new PlaneFactory();
		}
		else if(type.equals(CHECKER_PLANE_FACTORY)){
			rf = new CheckerPlaneFactory();
		}
		return rf;
	}

	private Renderable decorate(String decoration, Renderable rend){
		Renderable decoratedRenderable = null;

		try{
			//attempt to load a class named "<decoration>Decorator"
			Class<?> decoratorClass = Class.forName(
				CLASS_PREFIX + decoration + DECO_SUFFIX);
			//load the constructor and call it
			Constructor decoCon = decoratorClass.getConstructor(
				Renderable.class);
			decoratedRenderable = (Renderable)decoCon.newInstance(rend);
		} catch(ClassNotFoundException e){}
		catch(NoSuchMethodException e) {}
		catch(InstantiationException e) {}
		catch(IllegalAccessException e) {}
		catch(InvocationTargetException e) {}

		return decoratedRenderable;
	}

	protected Renderable decorateRenderable(String[] decoList, Renderable rend){
		Renderable decodRenderable = rend;
		for(int index = 0; index < decoList.length; index++){
			decodRenderable = decorate(decoList[index], decodRenderable);
		}
		return decodRenderable;
	}

	protected Renderable decorateRenderable(String decoList, Renderable rend){
		return decorateRenderable(decoList.split(SEPERATOR), rend);
	}

	public abstract Renderable newRenderable(String type);
}
