package rbs.render;

import java.io.Serializable;
import java.io.BufferedReader;
import java.io.IOException;
import javax.vecmath.Point3f;

public abstract class RenderableDecorator extends Renderable implements 
	Cloneable, Serializable{

	private Renderable renderable;

	public RenderableDecorator(Renderable renderable){
		this.renderable = renderable;
	}

	public Renderable getCoreRenderable(){
		return this.renderable;
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		this.renderable.loadFromFile(input);
	}

	public Object clone() throws CloneNotSupportedException{
		RenderableDecorator rd = (RenderableDecorator)super.clone();
		rd.renderable = (Renderable)this.renderable.clone();
		return (Object)rd;
	}

	public boolean isDecorated(){
		return true;
	}

	//I have to remember if I add something to renderable to add methods here
	public Point3f getOrientation(){
		return this.renderable.getOrientation();
	}

	public float getPitch(){
		return this.renderable.getPitch();
	}

	public float getYaw(){
		return this.renderable.getYaw();
	}

	public float getRoll(){
		return this.renderable.getRoll();
	}

	public void setOrientation(Point3f orient){
		this.renderable.setOrientation(orient);
	}

	public void setOrientation(float pitch, float yaw, float roll){
		this.setPitch(pitch);
		this.setYaw(yaw);
		this.setRoll(roll);
	}

	public void setPitch(float pitch){
		this.renderable.setPitch(pitch);
	}

	public void setYaw(float yaw){
		this.renderable.setYaw(yaw);
	}

	public void setRoll(float roll){
		this.renderable.setRoll(roll);
	}

	public Point3f getLocation(){
		return this.renderable.getLocation();
	}

	public float getX(){
		return this.renderable.getX();
	}

	public float getY(){
		return this.renderable.getY();
	}

	public float getZ(){
		return this.renderable.getZ();
	}

	public void setLocation(Point3f loc){
		this.renderable.setLocation(loc);
	}

	public void setLocation(float x, float y, float z){
		this.setX(x);
		this.setY(y);
		this.setZ(z);
	}

	public void setX(float x){
		this.renderable.setX(x);
	}

	public void setY(float y){
		this.renderable.setY(y);
	}

	public void setZ(float z){
		this.renderable.setZ(z);
	}
}
