package rbs.render;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import javax.vecmath.Point2f;

public class Plane extends Renderable implements Cloneable, Serializable{
	private float width;
	private float height;

	public Plane(){
		this.width = 1.0f;
		this.height = 1.0f;
	}

	public void setWidth(float width){
		this.width = width;
	}

	public float getWidth(){
		return this.width;
	}

	public void setHeight(float height){
		this.height = height;
	}

	public float getHeight(){
		return this.height;
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		super.loadFromFile(input);
		this.setWidth(Float.parseFloat(input.readLine()));
		this.setHeight(Float.parseFloat(input.readLine()));
	}

	public Object clone() throws CloneNotSupportedException{
		return super.clone();
	}

	//appropriate glBegin must be called before this.
	//automatically drawn in xy plane if you want it somewhere else you will
	//have to rotate it.
	protected void renderQuad(GL gl, Point2f topLeft, Point2f bottomRight){
		gl.glNormal3f(0.0f, 0.0f, 1.0f);
		gl.glVertex3f(topLeft.x, topLeft.y, 0.0f);
		gl.glVertex3f(topLeft.x, bottomRight.y, 0.0f);
		gl.glVertex3f(bottomRight.x, bottomRight.y, 0.0f);
		gl.glVertex3f(bottomRight.x, topLeft.y, 0.0f);
	}

	//this function does not set a color that needs to be done by someone else
	public void renderOpenGL(GL gl, GLU glu, GLUquadric gluQuad){
		//move to proper position
		gl.glTranslatef(this.getX(), this.getY(), this.getZ());
		gl.glRotatef(this.getRoll(), ROLL_X, ROLL_Y, ROLL_Z);
		gl.glRotatef(this.getPitch(), PITCH_X, PITCH_Y, PITCH_Z);
		gl.glRotatef(this.getYaw(), YAW_X, YAW_Y, YAW_Z);
		//draw the plane
		float halfWidth = this.width / 2.0f;
		float halfHeight = this.height / 2.0f;
		gl.glBegin(gl.GL_QUADS);
		this.renderQuad(gl, new Point2f(-halfWidth, halfHeight),
			new Point2f(halfWidth, -halfHeight));
		gl.glEnd();
	}
}
