package rbs.reel;

import rbs.SimulationState;
import java.util.ArrayDeque;
import java.lang.NullPointerException;
import java.util.NoSuchElementException;

public class StreamFrameReel implements FrameReel{
	private ArrayDeque<StillFrame> film;

	public StreamFrameReel(){
		film = new ArrayDeque<StillFrame>();
	}

	public synchronized StillFrame popFrame(){
		StillFrame frame = film.poll();
		return frame;
	}

	public synchronized boolean isBuffered(){
		return false;
	}

	public synchronized boolean pushFrame(StillFrame frame){
		try{
			return film.add(frame);
		} catch(NullPointerException e){
			return false;
		}
	}

	public synchronized int reelLength(){
		return film.size();
	}
}
