package rbs;

import rbs.config.ConfigFile;

public class RbsConfig extends ConfigFile{
	private static final int NUM_SETTINGS = 61;

	//the class that reads the setting specifies the name
	public RbsConfig(String filename){
		super(filename, RbsConfig.NUM_SETTINGS);

		addString(SimulationState.DEBUG_SETTING);

		addInteger(RigidBodySimulator.NUM_RENDERERS_SETTING);
		addString(RigidBodySimulator.R0_TYPE_SETTING);
		addString(RigidBodySimulator.R1_TYPE_SETTING);
		addString(RigidBodySimulator.R2_TYPE_SETTING);
		addString(RigidBodySimulator.R3_TYPE_SETTING);
		addInteger(RigidBodySimulator.R_WIDTH_SETTING);
		addInteger(RigidBodySimulator.R_HEIGHT_SETTING);

		addFloat(RigidBodySimulator.R0_FLEFT_SETTING);
		addFloat(RigidBodySimulator.R1_FLEFT_SETTING);
		addFloat(RigidBodySimulator.R2_FLEFT_SETTING);
		addFloat(RigidBodySimulator.R3_FLEFT_SETTING);

		addFloat(RigidBodySimulator.R0_FRIGHT_SETTING);
		addFloat(RigidBodySimulator.R1_FRIGHT_SETTING);
		addFloat(RigidBodySimulator.R2_FRIGHT_SETTING);
		addFloat(RigidBodySimulator.R3_FRIGHT_SETTING);
		
		addFloat(RigidBodySimulator.R0_FNEAR_SETTING);
		addFloat(RigidBodySimulator.R1_FNEAR_SETTING);
		addFloat(RigidBodySimulator.R2_FNEAR_SETTING);
		addFloat(RigidBodySimulator.R3_FNEAR_SETTING);

		addFloat(RigidBodySimulator.R0_FFAR_SETTING);
		addFloat(RigidBodySimulator.R1_FFAR_SETTING);
		addFloat(RigidBodySimulator.R2_FFAR_SETTING);
		addFloat(RigidBodySimulator.R3_FFAR_SETTING);

		addFloat(RigidBodySimulator.R0_CAMERAX_SETTING);
		addFloat(RigidBodySimulator.R1_CAMERAX_SETTING);
		addFloat(RigidBodySimulator.R2_CAMERAX_SETTING);
		addFloat(RigidBodySimulator.R3_CAMERAX_SETTING);

		addFloat(RigidBodySimulator.R0_CAMERAY_SETTING);
		addFloat(RigidBodySimulator.R1_CAMERAY_SETTING);
		addFloat(RigidBodySimulator.R2_CAMERAY_SETTING);
		addFloat(RigidBodySimulator.R3_CAMERAY_SETTING);

		addFloat(RigidBodySimulator.R0_CAMERAZ_SETTING);
		addFloat(RigidBodySimulator.R1_CAMERAZ_SETTING);
		addFloat(RigidBodySimulator.R2_CAMERAZ_SETTING);
		addFloat(RigidBodySimulator.R3_CAMERAZ_SETTING);

		addFloat(RigidBodySimulator.R0_LOOKATX_SETTING);
		addFloat(RigidBodySimulator.R1_LOOKATX_SETTING);
		addFloat(RigidBodySimulator.R2_LOOKATX_SETTING);
		addFloat(RigidBodySimulator.R3_LOOKATX_SETTING);

		addFloat(RigidBodySimulator.R0_LOOKATY_SETTING);
		addFloat(RigidBodySimulator.R1_LOOKATY_SETTING);
		addFloat(RigidBodySimulator.R2_LOOKATY_SETTING);
		addFloat(RigidBodySimulator.R3_LOOKATY_SETTING);

		addFloat(RigidBodySimulator.R0_LOOKATZ_SETTING);
		addFloat(RigidBodySimulator.R1_LOOKATZ_SETTING);
		addFloat(RigidBodySimulator.R2_LOOKATZ_SETTING);
		addFloat(RigidBodySimulator.R3_LOOKATZ_SETTING);

		addString(RigidBodySimulator.REEL_TYPE_SETTING);

		addString(RigidBodySimulator.SIM_OBJECT_FILE_SETTING);
		addString(RigidBodySimulator.SIM_MATERIAL_FILE_SETTING);
		addInteger(RigidBodySimulator.SIM_NUM_TIMESTEPS_SETTING);
		addFloat(RigidBodySimulator.SIM_TIMESTEP_SIZE_SETTING);
		addBoolean(RigidBodySimulator.SIM_PAUSE_ON_COLLISION);

		addFloat(RigidBodySimulator.SIM_GRAVITY_X_SETTING);
		addFloat(RigidBodySimulator.SIM_GRAVITY_Y_SETTING);
		addFloat(RigidBodySimulator.SIM_GRAVITY_Z_SETTING);
		addBoolean(RigidBodySimulator.SIM_GRAVITY_FORCE);
		addBoolean(RigidBodySimulator.SIM_FRICTION);

		addBoolean(RigidBodySimulator.UI_COMMAND_LINE);
		addBoolean(RigidBodySimulator.UI_PLAYBACK_CLI);
		addBoolean(RigidBodySimulator.UI_PLAYBACK_GUI);
		addBoolean(RigidBodySimulator.UI_SERIAL_REEL_CLI);
		addBoolean(RigidBodySimulator.UI_SERIAL_REEL_GUI);
	}
}
