#!/usr/local/bin/python3

import subprocess
import cgi
import nsutil

def main():
	getdata = cgi.FieldStorage()

	host = getdata["host"].value.strip()
	prop = getdata["property"].value.strip()
	baselines = []	

	try:
		for value in getdata["baseline"]:
			baselines.append(value.value.strip())
	except TypeError:
			baselines.append(getdata["baseline"].value.strip())

	print("Content-type: text/html\r\n\r\n", end="")
	print("<html>\n<body>\n")
	print(host)
	print(prop)
	print(baselines)

	# Generate a baseline profile for each baseline
	# Format for files: host_property_num.dat
	# files at : /var/nodescape/html/base/assets/host_property_num.dat
	# Store profiles in a profiles directory
	fromdir = "/var/nodescape/html/base/assets/"
	todir = "/var/nodescape/bin/profiles/"

	for num in baselines:
		runcmd = ("./build_profile profile.conf %s/%s_%s.dat >%s/%s_%s.prof"
					%(fromdir, nsutil.rrd_name(host, prop), num, todir,
						nsutil.rrd_name(host, prop), num))
		print("<br>")
		print(runcmd)
		subprocess.call(runcmd, shell=True)


main()
