public class dimensionFloat extends Dimension{
	public double value;
	public String distanceName = "meters", timeName = "seconds", massName = "grams";
	
	/*
	 * Precondition: all given varibles are of the correct type
	 * Postcondition: I make a dimensionFloat with (base = b, distance= distance, time = time, mass= mass)
	 */
	public dimensionFloat(double base, int distance, int time, int mass){
		value = base;
		dimension[0] = distance;
		dimension[1] = time;
		dimension[2] = mass;
	}//end dimensionFloat constructer
	
	/*
	 * Precondition: all given varibles are of the correct type
	 * Postcondition: I make a dimensionFloat with (base = b, distance= distance, time = time, mass= mass)
	 */
	public dimensionFloat(double base, Dimension dim){
		value = base;
		
		dimension[0] = dim.dimension[0];
		dimension[1] = dim.dimension[1];
		dimension[2] = dim.dimension[2];
	}//end dimensionFloat constructer
	
	/*
	 * Precondition: none.
	 * Postcondition: I make a dimensionFloat with (base=1, distance=1, time=1, mass=1)
	 */
	public dimensionFloat(){
		value = 1.0;
		dimension[0] = 0;
		dimension[1] = 0;
		dimension[2] = 0;
	}//end dimensionFloat constructer
	
	/*
	 * Precondition: A base, int.
	 * Postcondition: I make a dimensionFloat with (base=1, distance=1, time=1, mass=1)
	 */
	public dimensionFloat(double base){
		value = base;
		dimension[0] = 0;
		dimension[1] = 0;
		dimension[2] = 0;
	}//end dimensionFloat constructer
	
	/*
	 * Precondition: A dimensionFloat, dim.
	 * Postcondition: I make a dimensionFloat that is the same as the one given
	 */
	public dimensionFloat(dimensionFloat dim){
		value = dim.getBase();
		dimension[0] = dim.dimension[0];
		dimension[1] = dim.dimension[1];
		dimension[2] = dim.dimension[2];
	}//end dimensionFloat constructer
	
	/*
	 * Precondition: none.
	 * Postcondition: I return the base
	 */
	public double getBase(){return value;}
	
	
	/*
	 * Precondition: a variable of type double, newBase
	 * Postcondition: I set the base to newBase
	 */
	private void setBase(double newBase){value = newBase;}
	
	/*
	 * Precondition: 2 demensionFloats, dim and dim2
	 * Postcondition: return the result from adding dim to dim2
	 */
	public static dimensionFloat add(dimensionFloat dim, dimensionFloat dim2){
		int length = dim.dimension.length;
		String error = "";
		Dimension dimTest = new Dimension(dim.dimension);
		Dimension dim2Test = new Dimension(dim2.dimension);
		
		if(!dimTest.equals(dim2Test))
			error = error + " Dimensions unequal.";
		
		//build the result dimensionFloat
		//else{
			int dis = dim.dimension[0], time = dim.dimension[1], mass = dim.dimension[2];
			dimensionFloat result = new dimensionFloat(dim.value + dim2.value, dis, time, mass);
			return result;
		//}end else
	}//end add
	
	/*
	 * Precondition: 2 demensionFloats, dim and dim2
	 * Postcondition: return the result from adding dim to dim2
	 */
	public dimensionFloat add(dimensionFloat dim){
		int length = dim.dimension.length;
		String error = "";
		
		//checking if they are the same dimensions
		for(int dimensionIndex = 0; dimensionIndex<length; dimensionIndex++){
			if(dim.dimension[dimensionIndex]!=this.dimension[dimensionIndex]){
				error = error + dim.dimension[dimensionIndex]+ " must equal " +
				this.dimension[dimensionIndex] + ".";
			}
		}
		
		//build the result dimensionFloat
		//else{
			int dis = dim.dimension[0], time = dim.dimension[1], mass = dim.dimension[2];
			dimensionFloat result = new dimensionFloat(dim.value + this.value, dis, time, mass);
			return result;
		//}end else
	}//end add
	
	/*
	 * Precondition: 2 demensionFloats, dimBig and dimSmall
	 * Postcondition: return the result from subtracting dimSmall from dimBig
	 */
	public static dimensionFloat subtract(dimensionFloat dimBig, dimensionFloat dimSmall){
		//make a temp so that I cannot mess with the origional
		dimensionFloat temp = new dimensionFloat(dimSmall.value, 
				dimSmall.getArray()[0], dimSmall.getArray()[1],dimSmall.getArray()[2]);
		temp.setBase(temp.getBase()*-1);
		
		return (dimensionFloat.add(dimBig, temp));
	}//end subtract
	
	/*
	 * Precondition: 2 demensionFloats, dimBig and dimSmall
	 * Postcondition: return the result from subtracting dimSmall from dimBig
	 */
	public dimensionFloat subtract(dimensionFloat dimSmall){
		//make a temp so that I cannot mess with the origional
		dimensionFloat temp = new dimensionFloat(dimSmall.value, 
				dimSmall.getArray()[0], dimSmall.getArray()[1],dimSmall.getArray()[2]);
		temp.setBase(temp.getBase()*-1);
		
		return (dimensionFloat.add(this, temp));
	}//end subtract
			
	/*
	 * Precondition: 2 demensionFloats, dim and dim2
	 * Postcondition: return the result from multiplying dim by dim2
	 */
	public static dimensionFloat multiply(dimensionFloat dim, dimensionFloat dim2){
		Dimension dimOne = new Dimension(dim.getArray()[0], dim.getArray()[1],
				dim.getArray()[2]);
		Dimension dimTwo = new Dimension(dim2.getArray()[0], dim2.getArray()[1]
			    ,dim2.getArray()[2]);
		Dimension multiplied = dimOne.add(dimTwo);
				
		//build the result dimensionFloat
		dimensionFloat result = new dimensionFloat(dim.value * dim2.value, multiplied
				.getArray()[0], multiplied.getArray()[1], multiplied.getArray()[2]);
		return result;
	}//end multiply
	
	/*
	 * Precondition: 2 demensionFloats, dim and dim2
	 * Postcondition: return the result from multiplying dim by dim2
	 */
	public dimensionFloat multiply(dimensionFloat dim){
		Dimension dimOne = new Dimension(dim.getArray()[0], dim.getArray()[1],
				dim.getArray()[2]);
		Dimension dimTwo = new Dimension(this.getArray()[0], this.getArray()[1]
			    ,this.getArray()[2]);
		Dimension multiplied = dimOne.add(dimTwo);
				
		//build the result dimensionFloat
		dimensionFloat result = new dimensionFloat(dim.value * this.value, multiplied
				.getArray()[0], multiplied.getArray()[1], multiplied.getArray()[2]);
		return result;
	}//end multiply
	
	/*
	 * Precondition: 2 demensionFloats, dimNum and dimDenom
	 * Postcondition: return the result from dividing dimNum by dimDenom
	 */
	public static dimensionFloat divide(dimensionFloat dimNum, dimensionFloat dimDenom){
		//cannot divide by zero
		if(dimDenom.value == 0)
			throw new ArithmeticException();
		
		//make a temp so that I cannot mess with the origional
		dimensionFloat temp = new dimensionFloat(dimDenom.value, 
				dimDenom.getArray()[0], dimDenom.getArray()[1],dimDenom.getArray()[2]);
		//altering that temp so it can be multiplied
		temp.setBase(1/temp.getBase());
		temp.dimension[0]*=-1;
		temp.dimension[1]*=-1;
		temp.dimension[2]*=-1;
		
		return (dimensionFloat.multiply(dimNum, temp));
	}//end divide
	
	/*
	 * Precondition: 2 demensionFloats, dimNum and dimDenom
	 * Postcondition: return the result from dividing dimNum by dimDenom
	 */
	public dimensionFloat divide(dimensionFloat dimDenom){
		//cannot divide by zero
		if(dimDenom.value == 0)
			throw new ArithmeticException();
		
		//make a temp so that I cannot mess with the origional
		dimensionFloat temp = new dimensionFloat(dimDenom.value, 
				dimDenom.getArray()[0], dimDenom.getArray()[1],dimDenom.getArray()[2]);
		//altering that temp so it can be multiplied
		temp.setBase(1/temp.getBase());
		temp.dimension[0]*=-1;
		temp.dimension[1]*=-1;
		temp.dimension[2]*=-1;
		
		return (dimensionFloat.multiply(this, temp));
	}//end divide
	
	/*
	 * Precondition: a double, base2 that is the float 
	 * Postcondition: return a dimension float that is the dm that called this * base2
	 */
	public dimensionFloat times(double base2){
		dimensionFloat temp = new dimensionFloat(this.getBase(), this.getArray()[0], 
				this.getArray()[1], this.getArray()[2]);
		temp.setBase(temp.getBase()*base2);
		return temp;
	}//end times
	
	/*
	 * Precondition: an int, base2 that is the float 
	 * Postcondition: return a dimension float that is the dm that called this * base2
	 */
	public dimensionFloat times(int base2){
		dimensionFloat temp = new dimensionFloat(this.getBase(), this.getArray()[0], 
				this.getArray()[1], this.getArray()[2]);
		temp.setBase(temp.getBase()*base2);
		return temp;
	}//end times
	
	/*
	 * Precondition: 1 dimensionFloat, dimF
	 * Postcondition: return true if dimensioFloats are equal, false if they are not
	 */
	public boolean equals(dimensionFloat dimF){
		if(this.value != dimF.value)
			return false;
		
		for(int index = 0; index<this.dimension.length; index++)
			if(this.dimension[index] != dimF.dimension[index])
				return false;
		return true;
	}//end equals
	
	/*
	 * Precondition: a variable of type dimensionFloat, d
	 * Postcondition: I return -1, if the caller[this] is smaller then the parameter
	 * 						    0, if the caller[this] is uqual to the paramenter
	 * 							1, if the caller[this] is greater then the parameter
	 */
	public int compareTo(dimensionFloat d){
		int myDis = this.dimension[0];
		int myTime = this.dimension[1];
		int myMass = this.dimension[2];
		double myValue = this.value;
		
		int hisDis = d.dimension[0];
		int hisTime = d.dimension[1];
		int hisMass = d.dimension[2];
		double hisValue = d.value;
		
		
		if(myDis>hisDis){
			return 1;
		}
		else if(myDis == hisDis){
			if(myValue>hisValue){
				return 1;
			}
			else if(myValue==hisValue){
				if(myValue>hisValue){
					return 1;
				}
				else if(myValue == hisValue){
					if(myTime>hisTime){
						return 1;
					}
					else if(myTime == hisTime){
						if(myValue>hisValue){
							return -1;
						}
						else if(myValue==hisValue){
							if(myMass > hisMass){
								return 1;
							}
							else if(myMass == hisMass){
								return 0;
							}
							else
								return -1;
						}
						else
							return -1;
					}
					else
						return -1;
				}
				else
					return -1;
			}
			else
				return -1;
		}
		else
			return -1;
	}//end compareTo
	
	/*
	 * Precondition: none
	 * Postcondition: return true if it is a float, false if it has exponents
	 */
	public boolean isFloat(){
		if(this.dimension[0] == 0)
			if(this.dimension[1] == 0)
				if(this.dimension[2] == 0)
					return true;
		return false;
	}//end isFloat
	
	public dimensionFloat squareRoot(){
		dimensionFloat DimResult;
		
		if(this.isEven()){
			DimResult = new dimensionFloat(Math.sqrt(this.getBase()), super.squareRootExp());
			return DimResult;
		}
		else{
			System.out.println("Cannot squareRoot, it isnt even.");
			return null;
		}
	}//end squareRoot
	
	public dimensionFloat toPower(int power){
		dimensionFloat newD = new dimensionFloat(this);
		
		newD.dimension[0] = this.dimension[0] * power;
		newD.dimension[1] = this.dimension[1] * power;
		newD.dimension[2] = this.dimension[2] * power;
		
		if(power<0){
			newD.value = Math.pow(newD.value, Math.abs(power));
			newD.value = (1/newD.value);
		}
		else if(power ==0){
			newD.value = 1;
		}
		else{
			newD.value = Math.pow(newD.value, power);
		}
		
		return newD;
	}
	
	/*
	 * Precondition: none
	 * Postcondition: return the string version of dimensionFloat
	 */
	public String toString(){
		return (this.getBase() + " with: " + dimension[0] + " " + distanceName + ", " + dimension[1] + " " + 
				timeName + ", "	+ dimension[2] + " " + massName + ".");
	}//end toString

}//end class
