import java.util.Hashtable;


public class Units {
		static Hashtable units = new Hashtable();
		static Hashtable timeUnits = new Hashtable();
		static Hashtable massUnits = new Hashtable();
		static Hashtable distanceUnits = new Hashtable();
		static Hashtable accelUnits = new Hashtable();
		static Hashtable velocUnits = new Hashtable();
	
		//base units
		public static final dimensionFloat second = new dimensionFloat(1.0,0,1,0);
		public static final dimensionFloat meter = new dimensionFloat(1.0,1,0,0);
		public static final dimensionFloat gram = new dimensionFloat(1.0,0,0,1);
		
		public static final dimensionFloat baseTime = second;
		public static final dimensionFloat baseDistance = meter;
		public static final dimensionFloat baseMass = gram;
		
		
				
		//aditional time units
		public static final dimensionFloat minute = new dimensionFloat(second.times(60));
		public static final dimensionFloat hour = new dimensionFloat(minute.times(60));
		public static final dimensionFloat day = hour.times(24);
		public static final dimensionFloat week = day.times(7);
		
		
		//aditional distance units
		public static final dimensionFloat centimeter = meter.times(1/100);
		public static final dimensionFloat kilometer = meter.times(1000);
		public static final dimensionFloat foot = meter.times(.3048);
		public static final dimensionFloat yard = foot.times(3);
		public static final dimensionFloat mile = foot.times(5280);
		public static final dimensionFloat inch = foot.times(1/12);
		
		
		//aditional mass units
		public static final dimensionFloat kilogram = gram.times(1000);
		public static final dimensionFloat lb = gram.times(453.594);
		public static final dimensionFloat ounce = gram.times(28.350);
		public static final dimensionFloat slug = gram.times(14593.903);
		
		
		//AREA units
		public static final dimensionFloat squareMeter = new dimensionFloat(1.0,2,0,0);
		public static final dimensionFloat squareKilometer = new dimensionFloat(Math
				.pow(kilometer.getBase(), 2),2,0,0);
		public static final dimensionFloat squareCentimeter = new dimensionFloat(Math
				.pow(centimeter.getBase(), 2),2,0,0);
		
		public static final dimensionFloat squareFoot = new dimensionFloat(Math.pow
				(foot.getBase(), 2),2,0,0);
		public static final dimensionFloat squareYard = new dimensionFloat(Math.pow
				(yard.getBase(), 2),2,0,0);
		public static final dimensionFloat squareMile = new dimensionFloat(Math.pow
				(mile.getBase(), 2),2,0,0);
		public static final dimensionFloat squareInch = new dimensionFloat(Math.pow
				(inch.getBase(), 2),2,0,0);
		
		
		//VELOCITY UNITS
		public static final dimensionFloat meterPerSecond = new dimensionFloat(1.0,1,-1,0);
		public static final dimensionFloat meterPerHour = new dimensionFloat(1/
				(hour.getBase()),1,-1,0);
		public static final dimensionFloat meterPerDay = new dimensionFloat(1/
				(day.getBase()),1,-1,0);
		public static final dimensionFloat meterPerWeek = new dimensionFloat(1/
				(week.getBase()),1,-1,0);
		
		public static final dimensionFloat footPerSecond = new dimensionFloat(
				(foot.getBase())/(1),1,-1,0);
		public static final dimensionFloat footPerHour = new dimensionFloat(
				(foot.getBase())/(hour.getBase()),1,-1,0);
		public static final dimensionFloat footPerDay = new dimensionFloat(
				(foot.getBase())/(day.getBase()),1,-1,0);
		public static final dimensionFloat footPerWeek = new dimensionFloat(
				(foot.getBase())/(week.getBase()),1,-1,0);
		
		public Units(){
			//General Units
			units.put("SECOND", second);
			units.put("MINUTE", minute);
			units.put("HOUR", hour);
			units.put("DAY", day);
			units.put("WEEK", week);
			
			units.put("METER", meter);
			units.put("CENTIMETER", centimeter);
			units.put("KILOMETER", kilometer);
			units.put("FOOT", foot);
			units.put("YARD", yard);
			units.put("MILE", mile);
			units.put("INCH", inch);
			
			units.put("GRAM", gram);
			units.put("KILOGRAM", kilogram);
			units.put("POUND", lb);
			units.put("OUNCE", ounce);
			units.put("SLUG", slug);
			
			//Mass Units
			massUnits.put("GRAM", gram);
			massUnits.put("KILOGRAM", kilogram);
			massUnits.put("POUND", lb);
			massUnits.put("OUNCE", ounce);
			massUnits.put("SLUG", slug);
			
			//Time Units
			timeUnits.put("SECOND", second);
			timeUnits.put("MINUTE", minute);
			timeUnits.put("HOUR", hour);
			timeUnits.put("DAY", day);
			timeUnits.put("WEEK", week);
			
			//Distance Units
			distanceUnits.put("METER", meter);
			distanceUnits.put("CENTIMETER", centimeter);
			distanceUnits.put("KILOMETER", kilometer);
			distanceUnits.put("FOOT", foot);
			distanceUnits.put("YARD", yard);
			distanceUnits.put("MILE", mile);
			distanceUnits.put("INCH", inch);
			
			//Velocity Units
			distanceUnits.put("METER/SECOND", inch);
					
		}
		
		public dimensionFloat stringToDF(String name, int type){
			if(type == 1){//distance
				if(name.equalsIgnoreCase("meter"))
					return meter;
				else if(name.equalsIgnoreCase("centimeter"))
					return centimeter;
				else if(name.equalsIgnoreCase("kilometer"))
					return kilometer;
				else if(name.equalsIgnoreCase("foot"))
					return foot;
				else if(name.equalsIgnoreCase("yard"))
					return yard;
				else if(name.equalsIgnoreCase("mile"))
					return mile;
				else
					return inch;
			}//end distance
			else if(type == 2){//time
				if(name.equalsIgnoreCase("second"))
					return second;
				else if(name.equalsIgnoreCase("minute"))
					return minute;
				else if(name.equalsIgnoreCase("hour"))
					return hour;
				else if(name.equalsIgnoreCase("day"))
					return day;
				else 
					return week;
			}//end time
			else{//mass
				if(name.equalsIgnoreCase("gram"))
					return gram;
				else if(name.equalsIgnoreCase("kilogram"))
					return kilogram;
				else if(name.equalsIgnoreCase("pound"))
					return lb;
				else if(name.equalsIgnoreCase("ounce"))
					return ounce;
				else 
					return slug;
			}//end mass
				
		}//end StringtoDF
}
