import java.util.*;
public class DimensionGroup {
	//Each DimensionGroup...ie an equation...must have its equation in 
	//polish post fix
	//Example: .5 $1 times $2 plus
	
	//Member Variables
	public ArrayList Dimensions;
	public String information;
	public String EQUinformation;
	public Dimension endResult;
	
	/*
	 * Precondition: none
	 * Postcondition: Make a default DimensionGroup
	 */
	public DimensionGroup(){
		Dimensions = new ArrayList();
		information = "";
	}//end constructer
	
	/*
	 * Precondition: none
	 * Postcondition: Make a Dimension group with info "" and length size
	 */
	public DimensionGroup(int size){
		Dimensions = new ArrayList(size);
		information = "";
	}//end constructer
	
	/*
	 * Precondition: Stiring , into
	 * Postcondition: Make a Dimension group with information info and length 
	 * undifined
	 */
	public DimensionGroup(String info){
		Dimensions = new ArrayList();
		information = info;
	}//end constructer
	
	/*
	 * Precondition: Stiring , into
	 * Postcondition: Make a Dimension group with information info and length 
	 * undifined
	 */
	public DimensionGroup(String info, String info2){
		Dimensions = new ArrayList();
		information = info;
		EQUinformation = info2;
	}//end constructer
	
	/*
	 * Precondition: none
	 * Postcondition: Make a Dimension group with information info and length size
	 */
	public DimensionGroup(int size, String info){
		Dimensions = new ArrayList(size);
		information = info;
	}//end constructer
	
	/*
	 * Precondition: a Dimension, d
	 * Postcondition: add d to the array of Dimensions
	 */
	public void add(Dimension d){
		Dimensions.add(d);
	}//end add
	
	/*
	 * Precondition: a Dimension, d
	 * Postcondition: return true if the array contains d, false if it does not
	 */
	private boolean exists(Dimension d){
		return Dimensions.contains(d);
	}//end exists
	
	/*
	 * Precondition: none
	 * Postcondition: return the size of dimensions
	 */
	public int size(){
		return this.Dimensions.size();
	}//end size
	
	/*
	 * Precondition: a int, index
	 * Postcondition: return true if the array contains index, false if it does not
	 */
	public boolean exists(int index){
		return Dimensions.size() > index;
	}//end exists
	
	/*
	 * Precondition: a Dimension, d
	 * Postcondition: remove the d if it exits, otherwise throw an exception
	 */
	private void remove(Dimension d){
		if(this.exists(d))
			Dimensions.remove(d);
		else{
			//throw new ArrayIndexOutOfBoundsException(d + " Doesn't Exist.");
			System.out.println(d + " Doesn't Exist.");
		}
	}//end remove
	
	/*
	 * Precondition: a Dimension, d
	 * Postcondition: if it is the same as the caller, return true, 
	 * else- return false
	 */
	private boolean equals(DimensionGroup d){
		if(this.size() != d.size())
			return false;
		
		for(int index = 0; index<d.size(); index++)
			if(!(this.lookAt(index).equals(d.lookAt(index))))
				return false;
		
		return true;
	}//end equals
	
	/*
	 * Precondition: an int, index
	 * Postcondition: if it exists, return the dimension at that index, 
	 * else return null
	 */
	protected Dimension lookAt(int index){
		if(this.exists(index))
			return ((Dimension)Dimensions.get(index));
		else{
			System.out.println(index + " Doesn't Exist.");
			return null;
		}
	}//end lookAt
	
	/*
	 * Precondition: an ArrayList, Dimension, and int
	 * Postcondition: return and int[] that compromises is the solved version
	 */
	public int[] solve(ArrayList dimension, Dimension goal, int lookedAt){
		int[] result = new int[dimension.size()];
		for(int indexA = -2; indexA<3; indexA++){
			Dimension first = new Dimension(((Dimension)dimension.get(0))
					.multiply(indexA));
			for(int indexB = -2; indexB< 3; indexB++){
				Dimension second = new Dimension(((Dimension)dimension.get(1))
						.multiply(indexB));
				if(((first).add((second))).equals(goal)){
					result[0] = indexA;
					result[1] = indexB;
					return result;
				}
			}
		}
		result = null;
		return result;
	}//end solve
	
	/*
	 * Precondition: an ArrayList, Dimension, Dimension, int and int[]
	 * Postcondition: return true if it is solvable, use recursion to solve, 
	 * 	add values to int[] that are the solution
	 */
	public boolean solveRec(ArrayList dimension,Dimension combSoFar, Dimension goal, 
			int treated, int[] solution){
		if(treated == dimension.size())
			return (combSoFar.equals(goal));
		else
			for(int power = -2; power<3; power++){
				Dimension newFactor = new Dimension(((Dimension)dimension
						.get(treated)).multiply(power));
				if(solveRec(dimension,combSoFar.add(newFactor), goal, treated+1, 
						solution)){
					solution[treated]=power;
					return true;
				}
			}
		return false;
	}//end solveRec
	
	/*
	 * Precondition: a DimensionGroup, dimG
	 * Postcondition: I use an insertion sort to sort the DimensionGroup given
	 */
	public static ArrayList sort(DimensionGroup dimG){
		//Needed Variables for Insertion Sort
		ArrayList dimensions = dimG.Dimensions;
		Dimension itemToInsert; 
		int j;
		boolean stillLooking;
		
		//on the kth pass, insert item K into its correct position among
		//the first k entries in array
		
		for (int k=1; k<dimensions.size(); k++){
				// Walk backwards through array, looking for a slot to insert a[k]
			itemToInsert = ((Dimension)dimensions.get(k));
			j = k-1;
			stillLooking = true;
			
			while((j >= 0) && stillLooking )
				if(itemToInsert.compareTo((Dimension)dimensions.get(j)) == 1) {
					dimensions.set(j+1, dimensions.get(j));
					j--;
				}
				else
					stillLooking = false;
			//upon leaving the loop, j+1 is the index were itemToInsert belongs.
			dimensions.set(j+1, itemToInsert);	
		}
		
		return dimensions;
	}//end sort
	
	/*
	 * Precondition: give me a sting of instruction: (".5 times first times 
	 * 	second times second")
	 * Postcondition: place the seperate words into an arrayList: [.5,times,
	 * first...]
	 */
	public ArrayList toArray(String instructions){
		ArrayList things = new ArrayList();
		int next = instructions.indexOf(" ");
		boolean finished = false;//exit varable
		
		//placing the first thing into instructions
		things.add(instructions.substring(0, next));
		
		while(finished == false){
			//changing instructions
			instructions = instructions.substring(next+1, instructions.length());
			next = instructions.indexOf(" ");//altering teh next varable
			if(next == -1){//if on the last word
				finished = true;//exit the loop
				next = instructions.length();
			}
			things.add(instructions.substring(0, next));
		}
		return things;
	}//end toArray
	
	/*
	 * Precondition: a DimensionGroup, old
	 * Postcondition: return ta copy of old
	 */
	public DimensionGroup clone(DimensionGroup old){
		DimensionGroup newD = new DimensionGroup();
		
		for(int index = 0; index<old.size(); index++){
			newD.add(old.lookAt(index));
		}
		
		return newD;
	}//end DimensionGroup
	
	/*
	 * Precondition: none
	 * Postcondition: return the string version of DimensionGroup
	 */
	public String toString(){
		String total = "";
		
		for(int index = 0; index<Dimensions.size(); index++)
			total = total + (Dimension)Dimensions.get(index) + "\n";		
		
		total = total + "wanted: " + endResult;
		return total;
	}//end toString
	
}//end DimensionGroup
