import java.util.ArrayList;

public class DimensionFloatGroup extends DimensionGroup{
	//Each DimensionFloatGroup...ie an equation...must have its equation in polish post fix
	//Example: .5 $1 times $2 plus
	
	public Dimension endResult;
	public static ArrayList terms;
	
	/*
	 * Precondition: none
	 * Postcondition: Make a default DimensionGroup
	 */
	public DimensionFloatGroup(){
		Dimensions = new ArrayList();
		information = "";
	}//end constructer
	
	/*
	 * Precondition: none
	 * Postcondition: Make a Dimension group with info "" and length size
	 */
	public DimensionFloatGroup(int size){
		Dimensions = new ArrayList(size);
		information = "";
	}//end constructer
	
	/*
	 * Precondition: none
	 * Postcondition: Make a Dimension group with information info and length size
	 */
	public DimensionFloatGroup(int size, String info){
		Dimensions = new ArrayList(size);
		information = info;
	}//end constructer
	
	/*
	 * Precondition: none
	 * Postcondition: Make a Dimension group with information info and length size
	 */
	public DimensionFloatGroup(int size, String info, Dimension fin){
		Dimensions = new ArrayList(size);
		information = info;
		endResult = new Dimension(fin);
	}//end constructer
	
	/*
	 * Precondition: Stiring , into
	 * Postcondition: Make a Dimension group with information info and length undifined
	 */
	public DimensionFloatGroup(String info){
		Dimensions = new ArrayList();
		information = info;
	}//end constructer
	
	/*
	 * Precondition: Stiring , into
	 * Postcondition: Make a Dimension group with information info and length undifined
	 */
	public DimensionFloatGroup(ArrayList list){
		Dimensions = list;
		information = "";
	}//end constructer
	
	/*
	 * Precondition: a DimensionFlaot, d
	 * Postcondition: add d to the array of Dimensions
	 */
	public void add(dimensionFloat d){
		Dimensions.add(d);
	}//end add
	
	/*
	 * Precondition: a DimensionFloat, d
	 * Postcondition: return true if the array contains d, false if it does not
	 */
	public boolean exists(dimensionFloat d){
		return Dimensions.contains(d);
	}//end exists
	
	/*
	 * Precondition: a DimensionFloat, d
	 * Postcondition: remove the d if it exits, otherwise throw an exception
	 */
	public void remove(dimensionFloat d){
		if(this.exists(d))
			Dimensions.remove(d);
		else{
			//throw new ArrayIndexOutOfBoundsException(d + " Doesn't Exist.");
			System.out.println(d + " Doesn't Exist.");
		}
	}//end remove
	
	/*
	 * Precondition: a DimensionFloat, d
	 * Postcondition: remove the d if it exits, otherwise throw an exception
	 */
	public void remove(int index){
		if(index>-1 && index<=Dimensions.size())
			Dimensions.remove(index);
		else{
			//throw new ArrayIndexOutOfBoundsException(d + " Doesn't Exist.");
			System.out.println(index + " Doesn't Exist.");
		}
	}//end remove
	
	/*
	 * Precondition: an int, index
	 * Postcondition: if it exists, return the dimensionFloat at that index, else return null
	 */
	public dimensionFloat lookAT(int index){
		if(this.exists(index))
			return ((dimensionFloat)Dimensions.get(index));
		else{
			System.out.println(index + " Doesn't Exist.");
			return null;
		}
	}//end lookAt
	
	/*
	 * Precondition: a DimensionFloatGroup, d
	 * Postcondition: if it is the same as the caller, return true, else- return false
	 */
	private boolean equals(DimensionFloatGroup d){
		if(this.size() != d.size())
			return false;
		
		for(int index = 0; index<d.size(); index++)
			if(!(this.lookAt(index).equals(d.lookAt(index))))
				return false;
		
		return true;
	}//end equals
	
	/*
	 * Precondition: a DimensionFloatGroup, d
	 * Postcondition: if it is the same units as the caller, return true, else- return false
	 */
	public boolean sameUnit(DimensionGroup d){
		if(this.Dimensions.size() != d.Dimensions.size())
			return false;
		
		for(int index = 0; index< this.Dimensions.size(); index++)
			if(!((Dimension)(this.lookAt(index))).equals((Dimension)(d.lookAt(index))))
				return false;
				
		return true;
	}//end sameUnit
	
	public int belongAsEquation(equations equ){
		DimensionFloatGroup sorted = new DimensionFloatGroup(DimensionFloatGroup.sort(this));
		for(int index = 0; index<equ.Equations.size(); index++)
			if(sorted.sameUnit((DimensionGroup)(equ.Equations.get(index))))
				return index;
		
		return -1;
	}
	/*
	 * Precondition: a DimensionFloatGroup, dimG
	 * Postcondition: I use an insertion sort to sort the DimensionFloatGroup given
	 */
	public static ArrayList sort(DimensionFloatGroup dimG){
		//Needed Variables for Insertion Sort
		ArrayList dimensions = dimG.Dimensions;
		dimensionFloat itemToInsert; 
		int j;
		boolean stillLooking;
		
		//on the kth pass, insert item K into its correct position among
		//the first k entries in array
		
		for (int k=1; k<dimensions.size(); k++){
				// Walk backwards through array, looking for a slot to insert a[k]
			itemToInsert = ((dimensionFloat)dimensions.get(k));
			j = k-1;
			stillLooking = true;
			
			while((j >= 0) && stillLooking )
				if(itemToInsert.compareTo((dimensionFloat)dimensions.get(j)) == 1) {
					dimensions.set(j+1, dimensions.get(j));
					j--;
				}
				else
					stillLooking = false;
			//upon leaving the loop, j+1 is the index were itemToInsert belongs.
			dimensions.set(j+1, itemToInsert);	
		}
		
		return dimensions;
	}//end sort
	
	/*
	 * Precondition: an ArrayList, Dimension, Dimension, int and int[]
	 * Postcondition: return true if it is solvable, use recursion to solve, 
	 * 	add values to int[] that are the solution
	 */
	public boolean solveRec(ArrayList dimension,dimensionFloat combSoFar, 
			dimensionFloat goal, int treated, int[] solution){
		if(treated == dimension.size())
			return (combSoFar.equals(goal));
		else
			for(int power = -2; power<3; power++){
				Dimension newFactor = new Dimension(((Dimension)dimension.get(treated))
						.multiply(power));
				if(solveRec(dimension,combSoFar.add(newFactor), goal, treated+1, 
						solution)){
					solution[treated]=power;
					return true;
				}
			}
		return false;
	}//end solveRec
	
	/*
	 * Precondition: a DimensionFloatGroup, old
	 * Postcondition: return ta copy of old
	 */
	public DimensionFloatGroup clone(DimensionFloatGroup old){
		DimensionFloatGroup newD = new DimensionFloatGroup();
		
		for(int index = 0; index<old.size(); index++){
			newD.add(old.lookAt(index));
		}
		
		return newD;
	}//end DimensionGroup

	/* 
	 * Precondition: give me a DimensionFloatGroup, dfg
	 * Postcondition: I take the instructions and do what they say. Then return the result.
	 */
	public static dimensionFloat solveWithInstructions(DimensionFloatGroup dfg){
		//some objects that I need		
		Stack instructions = new Stack((Stack.toStack(dfg.information)).list);
		Stack action = new Stack();//the stack I will work with
		dimensionFloat dim1;//a dF that I will use in computations
		dimensionFloat dim2;//a dF that I will use in computations
		boolean first = true;
		
		//testing stuff
		System.out.println("in solveWithInstructions");
		System.out.println("instructions: " + instructions);
		System.out.println("size of instructions: " + instructions.getSize());
		
		//goes throught the needed times to solve the equation
		while(instructions.getSize()>0 || action.getSize()>1){
			
			if(first){
				//the first element in the stack will either be a number 
				//or an index of a dimensionFloat i need it to be a dimensionFloat
				//it cannot be an operator
				
				//put the first item on the stack
				action.push(instructions.pop());
								
				//error because first item cannot be an operator
				if(Stack.isElementOperator(action.peekTop())){
					System.out.println("ERROR in EQUATION");
					break;
				}
				
				//its an index to a dF
				else if(Stack.isElementIndex(action.peekTop())){//if its an index to a dF
					int index = Stack.elementIntoInt(action.pop());
					action.push(dfg.lookAT(index));
				}
				
				//its a scalar that has to be made into a dF
				else{
					Object numberAsObject = action.pop();
					double number = Double.parseDouble(numberAsObject.toString());
					
					dim1 = new dimensionFloat(number);
					action.push(dim1);
				}
				
				first = false;
			}//once i leave this if-loop, the first thing in action will be a dF
			
			else{//non-frist runs
				
				//makes sure that you only pop when instructions have more instructions
				if(instructions.getSize()>0){
					//place the element onto my stack
					action.push(instructions.pop());
				}
				
				//testing stuff
				System.out.println("action: " + action);
				
				//if its an operator
				if(Stack.isElementOperator(action.peekTop())){
					//I will now go through my different operators
					
					//squared
					if(((String)(action.peekTop())).equalsIgnoreCase("squared")){
						action.pop();//take the operator off
						dim1 = ((dimensionFloat)(action.pop()));//due to the if-loop
						action.push(dim1.multiply(dim1));
					}//end square
					
					//squareRoot
					else if(((String)(action.peekTop())).equalsIgnoreCase("squareRoot")){
						action.pop();//take the operator off
						dim1 = ((dimensionFloat)(action.pop()));//due to the if-loop
						dim2 = dim1.squareRoot();
						action.push(dim2);
					}//end squareRoot
					
					//times
					else if(((String)(action.peekTop())).equalsIgnoreCase("times")){
						action.pop();//take the operator off
						
						//now we have either an index or a number on top (element 1).
						//element 0 is a dimensionFloat
						
						if(Stack.isElementNumber(action.peekTop())){//if its a number
							double valueNew = Double.parseDouble((String)action.peekTop());
							dim1 = new dimensionFloat(valueNew,0,0,0);
							action.pop();//remove the unneded item because I have the 
										//information stored
							dim2 = ((dimensionFloat)(action.pop()));//due to the if-loop
							dim2 = dim2.multiply(dim1);
							action.push(dim2);//place the computed item back on
						}
						
						else if(Stack.isElementIndex(action.peekTop())){//if its an index
							int indexReal = Stack.elementIntoInt(action.peekTop());
							dim1 = dfg.lookAT(indexReal);
							action.pop();//remove the unneded item because I have the 
										//information stored
							dim2 = ((dimensionFloat)(action.pop()));//due to the if-loop
							dim2 = dim2.multiply(dim1);
							action.push(dim2);//place the computed item back on
						}
						
					}//end times
					
					//divide
					else if(((String)(action.peekTop())).equalsIgnoreCase("divide")){
						action.pop();//take the operator off
						
						//now we have either an index or a number on top (element 1).
						//element 0 is a dimensionFloat
						
						if(Stack.isElementNumber(action.peekTop())){//if its a number
							double valueNew = Double.parseDouble((String)action.peekTop());
							dim1 = new dimensionFloat(valueNew);
							action.pop();//remove the unneded item because I have the 
										//information stored
							dim2 = ((dimensionFloat)(action.pop()));//due to the if-loop
							dim2 = dim2.divide(dim1);
							action.push(dim2);//place the computed item back on
						}
						
						else if(Stack.isElementIndex(action.peekTop())){//if its an index
							int indexReal = Stack.elementIntoInt(action.peekTop());
							dim1 = dfg.lookAT(indexReal);
							action.pop();//remove the unneded item because I have the 
										//information stored
							dim2 = ((dimensionFloat)(action.pop()));//due to the if-loop
							dim2 = dim2.divide(dim1);
							action.push(dim2);//place the computed item back on
						}
						
					}//end divide
					
					//plus
					else if(((String)(action.peekTop())).equalsIgnoreCase("plus")){
						action.pop();//take the operator off
						
						//now we have either an index or a number on top (element 1).
						//element 0 is a dimensionFloat
						
						if(Stack.isElementNumber(action.peekTop())){//if its a number
							double valueNew = Double.parseDouble((String)action.peekTop());
							dim1 = new dimensionFloat(valueNew);
							action.pop();//remove the unneded item because I have the 
										//information stored
							dim2 = ((dimensionFloat)(action.pop()));//due to the if-loop
							dim2 = dim2.add(dim1);
							action.push(dim2);//place the computed item back on
						}
						
						//now we have either an index or a number
						else if(Stack.isElementIndex(action.peekTop())){//if its an index
							//dimensionFloat dim2;
							int indexReal = Stack.elementIntoInt(action.peekTop());
							dim1 = dfg.lookAT(indexReal);
							action.pop();//remove the unneded item because I have the 
										//information stored
							dim2 = ((dimensionFloat)(action.pop()));//due to the if-loop
							dim2 = dim2.add(dim1);
							action.push(dim2);//place the computed item back on
						}
						
					}//end plus
								
					
				}
						
				else if(Stack.isElementNumber(action.peekTop())){//if it is a number
					//testing stuff
					System.out.println("number is on top");
					System.out.println("");
					System.out.println("");
				}//end number
				
				else if(Stack.isElementIndex(action.peekTop())){//if it is an index to a Df
					//testing stuff
					System.out.println("index is on top ($)");
					System.out.println("");
					System.out.println("");
				}//end index
			}//end non-first run
		}//end while loop
		return ((dimensionFloat)(action.pop()));//return the final result
	}//end solveWithInstructions
	
	/*
	 * Precondition: none
	 * Postcondition: return arrayList of usable terms
	 */
	public static ArrayList getTerms(){
		terms = new ArrayList();
		terms.add(0,"times");
		terms.add(1,"plus");
		terms.add(2,"subtract");
		terms.add(3,"divide");
		terms.add(4,"squared");
		terms.add(5,"squareRoot");
		
		return terms;
	}
	/*
	 * Precondition: none
	 * Postcondition: return the string version of DimensionFloatGroup
	 */
	public String toString(){
		String total = "";
		
		for(int index = 0; index<Dimensions.size(); index++)
			total = total + (dimensionFloat)Dimensions.get(index) + "\n";
		
		total = total + "wanted: " + endResult;
		return total;
	}//end toString
}//end DimensionFloatGroup
