// file for packet manipulations 

#include <stdio.h>
#include <stdlib.h>
#include <arpa/inet.h>

#include "incl/defns.h"
#include "incl/msg_format.h"
#include "incl/args.h"

#define VERSION 1

HEADER *frame_packet(u_short msg_id, u_short opcode, generic_op_args *args ,u_short data_size)
{
	HEADER *packet = (HEADER *) malloc(sizeof(HEADER));
	memset(packet,0,sizeof(HEADER));
	packet->msg_id = htons(msg_id);
	packet->op_code = htons(opcode);
	packet->msg_len = htons(data_size+sizeof(HEADER));
	// memcpy(&(packet->op_args),args,sizeof(generic_op_args));
	// printf("Size of header is %d\n",sizeof(HEADER));
	return (packet);
}// end of frame_packet

fattr *frame_fattr(uid_t ownerid, gid_t grpid, mode_t mode, time_t acc_time, 
		time_t mod_time, time_t ctime, u_short ftype, u_int size, 
		u_int nlink, u_int blksize,u_int blocks)
{
	fattr *attr = (fattr *)malloc(sizeof(fattr));
	attr->uid = htons(ownerid);
	attr->gid = htons(grpid);
	attr->mode = htons(mode);
	attr->atime = htons(acc_time);
	attr->mtime = htons(mod_time);
	attr->ctime = htons(ctime);
	attr->ftype = htons(ftype);
	attr->size = htonl(size);
	attr->nlink = htonl(nlink);
	attr->blocksize = htonl(blksize);
	attr->blocks = htonl(blocks);
	return (attr);
}// end of frame_fattr

void print_header(HEADER *hdr) 
{
	printf("Printing the recvd message contents\n");
	printf("Message id :%d\n",ntohs(hdr->msg_id));
	printf("Message len :%d\n",ntohs(hdr->msg_len));
	printf("Message op code :%d\n",ntohs(hdr->op_code));
}

void print_fattr(fattr *attr)
{
	printf("Printing the Attributes for the file \n");
	printf("File owner id %d\n",ntohs(attr->uid));
	printf("File group id %d\n",ntohs(attr->gid));
	printf("File mode is %d\n",ntohs(attr->mode));
	printf("File acc time %d\n",ntohs(attr->atime));
	printf("File mod time %d\n",ntohs(attr->mtime));
	printf("-------------------------------------------\n");
}

void print_args(HEADER *hdr, int msg_code)
{
	printf("based on the code print the header \n");
}

void frame_result(HEADER *hdr, pdfsstat rescode, fattr *attr)
{
	hdr->op_args.svc_result.status = htons(rescode);
	memcpy(&(hdr->op_args.svc_result.attr),attr,sizeof(fattr));
}
void frame_diropargs(HEADER *hdr, pdfs_fh *fh, char *fname)
{
	memcpy(&(hdr->args_dirop.dir_fh),fh,PDFS_FHSIZE);
	strcpy(hdr->args_dirop.name,fname);
}

void  frame_diropres(HEADER *hdr, pdfs_fh *fh)
{
	memcpy(&hdr->op_args.svc_result.rslt.dirop_res,fh,PDFS_FHSIZE);
}

void frame_read(HEADER *hdr, pdfs_fh *fh, u_long offset, u_long howmuch)
{
	memcpy(&(hdr->args_read.fh),fh,PDFS_FHSIZE);
	hdr->args_read.offset = htonl(offset);
	hdr->args_read.howmuch = htonl(howmuch);
}

void frame_readres(HEADER *hdr, u_long count)
{
	hdr->op_args.svc_result.rslt.read_res.count = htonl(count);
}

void frame_write(HEADER *hdr, pdfs_fh *fh, u_long offset, u_long howmuch)
{
	memcpy(&hdr->args_write.fh, fh, PDFS_FHSIZE);
	hdr->args_write.offset = htonl(offset);
	hdr->args_write.howmuch = htonl(howmuch);
}

void  frame_rename(HEADER *hdr, pdfs_fh *from_fh, char *from_fname, pdfs_fh *to_fh, char *to_fname)
{
	memcpy(&hdr->args_rename.from.dir_fh,from_fh,PDFS_FHSIZE);
	memcpy(&hdr->args_rename.to.dir_fh,to_fh, PDFS_FHSIZE);
	strcpy(hdr->args_rename.from.name,from_fname);
	strcpy(hdr->args_rename.to.name,to_fname);
}

void  frame_createargs(HEADER *hdr, pdfs_fh *fh, char *fname, sattr *attribs)
{
	memcpy(&hdr->args_create.where.dir_fh,fh,PDFS_FHSIZE);
	strcpy(hdr->args_create.where.name,fname);
	memcpy(&hdr->args_create.attribs,attribs,sizeof(sattr));
}

void frame_createres(HEADER *hdr, pdfs_fh *fh)
{
	memcpy(&hdr->op_args.svc_result.rslt.create_res.fh, fh, PDFS_FHSIZE);
}

void frame_readdir(HEADER *hdr, pdfs_fh *fh, u_long cookie)
{
	memcpy(&hdr->args_readdir.dir,fh,PDFS_FHSIZE);
//	hdr->args_readdir.cookie = htonl(cookie);
}

void frame_readdirres(HEADER *hdr, u_long cookie, u_long count)
{
//	hdr->op_args.svc_result.rslt.readdir_res.cookie = htonl(cookie);
	hdr->op_args.svc_result.rslt.readdir_res.count = htonl(count);
}

void frame_setattrargs(HEADER *hdr, pdfs_fh *fh, sattr *attribs)
{
	memcpy(&hdr->op_args.sattrargs.fh,fh, PDFS_FHSIZE);
	memcpy(&hdr->op_args.sattrargs.attributes,attribs,sizeof(sattr));
}

