/* Author: Balakrishnan Rukmangathan
   ss_funcs.c : functions used by the user site to communicate with
   the storage site.
   For each request a tcp connection is made and the reqeust is sent and
   sending side is closed signifying the end of the packet. the storage site
   on receiving the packet serves the request and writes back on to the tcp 
   connection. 
*/

#include<stdio.h>
#include<unistd.h>
#include<signal.h>
#include<fcntl.h>
#include<stdlib.h>

#include <errno.h>

#include<sys/types.h>
#include<sys/stat.h>
#include<sys/socket.h>
#include<arpa/inet.h>
#include<netinet/in.h>

#include "pdfs.h"
#include "defns.h"
#include "msg_format.h"

#define ONE_BYTE 1
extern int errno;
static int msg_id = 0;


int send_and_recv(char *, int , char *, char *);
char *print_fh(pdfs_fh *);

int lookup(pdfs_fh *dir_fh, char *fname, pdfs_fh *new_fh, char *ss_addr)
{
	// lookup for a file and retrieve the file handle 
	int nbytes = 0;
	HEADER *pkt,inpkt;

	pkt = frame_packet(msg_id++, MSG_US2SS_LOOKUP , NULL ,10);
	frame_diropargs(pkt, dir_fh, fname);
	memset(&inpkt,0,sizeof(inpkt));
	nbytes = send_and_recv((char *)pkt,sizeof(HEADER),(char *)&inpkt,ss_addr);
	printf("Lookup returned %d bytes \n",nbytes);
	if (nbytes <= 0)  { free(pkt); return -1; }
	
	if (ntohs(inpkt.op_args.svc_result.status) == PDFS_OK) 
		{
			printf("Lookup was successful \n");
			printf("New file handle is %s \n",print_fh(&(inpkt.op_args.svc_result.rslt.dirop_res.fh)));
			print_fattr(&(inpkt.op_args.svc_result.attr));
			memset(new_fh,0,PDFS_FHSIZE);
			memcpy(new_fh, &(inpkt.op_args.svc_result.rslt.dirop_res),PDFS_FHSIZE);
			if S_ISREG(ntohs(inpkt.op_args.svc_result.attr.ftype)) 
				{ free(pkt); 	return 2; }
			if S_ISDIR(ntohs(inpkt.op_args.svc_result.attr.ftype))
			{free(pkt);	return 1; }
		}
	errno = ntohs(inpkt.op_args.svc_result.status);
	perror("Error in lookup is "); 
	// printf("Lookup returned %d \n",inpkt.op_args.svc_result.status);
	free(pkt);
	return -1;
}// end of lookup

int pdfs_read(pdfs_fh *fh, char **buffer, u_long  nbytes, u_long f_pos, 
		char *ss_addr )
{
	int bytecount;
	HEADER *pkt;
	char *tempbuff = (char *)malloc((sizeof(HEADER)+nbytes)*sizeof(char));

	pkt  = frame_packet(msg_id++, MSG_US2SS_READ , NULL ,10);
	frame_read(pkt, fh, f_pos , nbytes);
	//printf("Going to read for fh %s %s",print_fh(fh),print_fh(&pkt->args_read.fh));
	// printf("Tempbuff and pkt is %0x %0x \n",tempbuff,pkt);
	memset(tempbuff,0,sizeof(HEADER)+nbytes);
	bytecount = send_and_recv((char *)pkt, sizeof(HEADER), tempbuff, ss_addr);
	printf("Read returned %d bytes \n",bytecount);
	if (bytecount <= 0)  { free(tempbuff); free(pkt); return -1; }
	free(pkt);
	pkt = (HEADER *) tempbuff;
	//printf("Tempbuff and pkt is %0x %0x \n",tempbuff,pkt);
	if (ntohs(pkt->op_args.svc_result.status) == PDFS_OK) {
		int count = ntohl(pkt->op_args.svc_result.rslt.read_res.count);
		printf("number of bytes read is %d \n",count);
		*buffer = (char *)malloc(sizeof(char)*count);
		memcpy(*buffer,tempbuff+sizeof(HEADER),count);
		// clean up the tempbuff
		free(tempbuff);
		return count;
	}
	errno = ntohs(pkt->op_args.svc_result.status);
	perror("Error in read is ");
	free(tempbuff);
	return -1;
} // end of read

int pdfs_write(pdfs_fh *fh, char *buffer, u_long  nbytes, u_long f_pos, 
		char *ss_addr )
{
	int bytecount;
	HEADER *pkt;
	char *tempbuff = (char *)malloc((sizeof(HEADER)+nbytes)*sizeof(char));
	char *ptr = tempbuff;
	pkt  = frame_packet(msg_id++, MSG_US2SS_WRITE, NULL, 10);
	frame_write(pkt, fh, f_pos , nbytes);
	// printf("Going to write for fh %s %s",print_fh(fh),print_fh(&pkt->args_write.fh));
	// printf("Tempbuff and pkt is %x %x \n",tempbuff,pkt);
	memset(tempbuff,0,sizeof(HEADER)+nbytes);
	memcpy(ptr,pkt,sizeof(HEADER));
	ptr += sizeof(HEADER);
	memcpy(ptr,buffer,nbytes);
	memset(pkt,0,sizeof(HEADER));
	bytecount = send_and_recv(tempbuff, sizeof(HEADER)+nbytes, (char *)pkt, ss_addr);
	printf("write returned %d bytes \n",bytecount);
	if (bytecount <= 0)  { free(tempbuff); free(pkt); return -1; }
	if (ntohs(pkt->op_args.svc_result.status) == PDFS_OK) {
		printf("Successfuly wrote to the file \n");
		free(tempbuff);
		free(pkt);
		return 1; 
	}
	errno = ntohs(pkt->op_args.svc_result.status);
	perror("Error in write is :\n");
	free(tempbuff);
	free(pkt);
	return -1;
} // end of write


int pdfs_readdir(pdfs_fh *fh, char **buffer, char *ss_addr)
{
	int bytecount;
	HEADER *pkt;
	char *tempbuff = (char *)malloc(sizeof(HEADER)*sizeof(char)+255*PDFS_MAXNAMELEN);

	pkt  = frame_packet(msg_id++, MSG_US2SS_READDIR , NULL ,10);
	frame_readdir(pkt, fh, 0); // third parameter not used 
	memset(tempbuff,0,sizeof(HEADER));
	bytecount = send_and_recv((char *)pkt, sizeof(HEADER), tempbuff, ss_addr);
	printf("Readdir returned %d bytes \n",bytecount);
	if (bytecount <= 0) { free(pkt); free(tempbuff); return -1; }
	free(pkt);
	pkt = (HEADER *) tempbuff;
	//printf("Tempbuff and pkt is %x %x \n",tempbuff,pkt);
	if (ntohs(pkt->op_args.svc_result.status) == PDFS_OK) {
		int count=ntohl(pkt->op_args.svc_result.rslt.readdir_res.count);
		printf("number of entries is %d \n",count);
		*buffer = malloc(sizeof(char)*(bytecount-sizeof(HEADER)));
		memcpy(*buffer,tempbuff+sizeof(HEADER),bytecount-sizeof(HEADER));
		free(tempbuff);
		return count;
	}
	errno = ntohs(pkt->op_args.svc_result.status);
	perror("Error in readdir is \n");
	free(tempbuff);
	return -1;
}// end of readdir

int pdfs_setattr()
{
return 1;
}// end of setattr

int pdfs_getattr()
{
return 1;
}// end of setattr

int send_and_recv(char *out_buff, int outbytes, char *in_buff, char *ss_addr)
{
	int sockfd;
	int nbytes = 0;
        struct sockaddr_in srvr_addr;
	char c;

        memset(&srvr_addr,0,sizeof(srvr_addr));
        srvr_addr.sin_family = AF_INET;
        srvr_addr.sin_port = htons(SS_DEAMON_PORT);
        srvr_addr.sin_addr.s_addr = inet_addr(ss_addr);

        if ((sockfd = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)) < 0) {
                        perror("Error in creating the socket \n");
			return -1; 
	}
        if (connect(sockfd,(struct sockaddr *)&srvr_addr, 
				sizeof(srvr_addr)) < 0) {
		  perror("Error in connecting the service socket \n");
                  close(sockfd);
		  return -1;
        }
        if (send(sockfd,out_buff,outbytes,0) != outbytes) {
		  perror("Error in sending the packet \n");
                  return -1;
	}

	shutdown(sockfd,1);

	// pkt has been successfully sent. Now receive the service 
	// reply

   	while(recv(sockfd,&c,ONE_BYTE,0)) {
            *(in_buff+nbytes) = c;
            nbytes++;
   	}
	if (nbytes == 0) 
		printf("Lost the connectivity to the storage site \n");
		// fault tolearnt issue
   return nbytes;
} // end of send_and_recv

